/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.HttpOperationFailedException;
import org.apache.camel.component.http.helper.GZIPHelper;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(HttpProducer.class);
    private HttpClient httpClient;
    private boolean throwException;

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.createHttpClient();
        this.throwException = endpoint.isThrowExceptionOnFailure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        block8: {
            HttpMethod method = this.createMethod(exchange);
            Message in = exchange.getIn();
            HeaderFilterStrategy strategy = ((HttpEndpoint)this.getEndpoint()).getHeaderFilterStrategy();
            for (String headerName : in.getHeaders().keySet()) {
                String headerValue = (String)in.getHeader(headerName, String.class);
                if (strategy == null || strategy.applyFilterToCamelHeaders(headerName, (Object)headerValue, exchange)) continue;
                method.addRequestHeader(headerName, headerValue);
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Executing http " + method.getName() + " method: " + method.getURI().toString()));
                }
                int responseCode = this.executeMethod(method);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Http responseCode: " + responseCode));
                }
                if (!this.throwException) {
                    this.populateResponse(exchange, method, in, strategy, responseCode);
                    break block8;
                }
                if (responseCode >= 100 && responseCode < 300) {
                    this.populateResponse(exchange, method, in, strategy, responseCode);
                    break block8;
                }
                throw this.populateHttpOperationFailedException(exchange, method, responseCode);
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    protected void populateResponse(Exchange exchange, HttpMethod method, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException {
        Header[] headers;
        Message answer = exchange.getOut();
        answer.setHeaders(in.getHeaders());
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        answer.setBody((Object)HttpProducer.extractResponseBody(method, exchange));
        for (Header header : headers = method.getResponseHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
            answer.setHeader(name, (Object)value);
        }
    }

    protected HttpOperationFailedException populateHttpOperationFailedException(Exchange exchange, HttpMethod method, int responseCode) throws IOException {
        HttpOperationFailedException exception;
        Header[] headers = method.getResponseHeaders();
        InputStream is = HttpProducer.extractResponseBody(method, exchange);
        if (responseCode >= 300 && responseCode < 400) {
            Header locationHeader = method.getResponseHeader("location");
            if (locationHeader != null) {
                String redirectLocation = locationHeader.getValue();
                exception = new HttpOperationFailedException(responseCode, method.getStatusLine(), redirectLocation, headers, is);
            } else {
                exception = new HttpOperationFailedException(responseCode, method.getStatusLine(), headers, is);
            }
        } else {
            exception = new HttpOperationFailedException(responseCode, method.getStatusLine(), headers, is);
        }
        return exception;
    }

    protected int executeMethod(HttpMethod method) throws IOException {
        return this.httpClient.executeMethod(method);
    }

    protected static InputStream extractResponseBody(HttpMethod method, Exchange exchange) throws IOException {
        InputStream is = method.getResponseBodyAsStream();
        if (is == null) {
            return null;
        }
        Header header = method.getRequestHeader("Content-Encoding");
        String contentEncoding = header != null ? header.getValue() : null;
        is = GZIPHelper.toGZIPInputStream(contentEncoding, is);
        return HttpProducer.doExtractResponseBody(is, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream doExtractResponseBody(InputStream is, Exchange exchange) throws IOException {
        try {
            CachedOutputStream cos = new CachedOutputStream(exchange.getContext().getProperties());
            IOHelper.copy((InputStream)is, (OutputStream)cos);
            InputStream inputStream = cos.getInputStream();
            return inputStream;
        }
        finally {
            ObjectHelper.close((Closeable)is, (String)"Extracting response body", (Log)LOG);
        }
    }

    protected HttpMethod createMethod(Exchange exchange) {
        String path;
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = ((HttpEndpoint)this.getEndpoint()).getHttpUri().getQuery();
        }
        RequestEntity requestEntity = this.createRequestEntity(exchange);
        HttpMethods m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class));
        HttpMethods methodToUse = m != null ? m : (queryString != null ? HttpMethods.GET : (requestEntity != null ? HttpMethods.POST : HttpMethods.GET));
        String uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        if (uri == null) {
            uri = ((HttpEndpoint)this.getEndpoint()).getHttpUri().toString();
        }
        if ((path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class)) != null) {
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            uri = uri.concat(path);
        }
        HttpMethod method = methodToUse.createMethod(uri);
        if (queryString != null) {
            method.setQueryString(queryString);
        }
        if (methodToUse.isEntityEnclosing()) {
            ((EntityEnclosingMethod)method).setRequestEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("No Content-Type provided for URI: " + uri + " with exchange: " + exchange));
            }
        }
        return method;
    }

    protected RequestEntity createRequestEntity(Exchange exchange) {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return null;
        }
        RequestEntity answer = (RequestEntity)in.getBody(RequestEntity.class);
        if (answer == null) {
            try {
                String data = (String)in.getBody(String.class);
                if (data != null) {
                    String contentType = ExchangeHelper.getContentType((Exchange)exchange);
                    String charset = (String)exchange.getProperty("CamelCharsetName", String.class);
                    answer = new StringRequestEntity(data, contentType, charset);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

