/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.helper;

import org.apache.camel.Exchange;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;

public final class HttpProducerHelper {
    private HttpProducerHelper() {
    }

    public static String createURL(Exchange exchange, HttpEndpoint endpoint) {
        String path;
        String uri = null;
        if (!endpoint.isBridgeEndpoint()) {
            uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        }
        if (uri == null) {
            uri = endpoint.getHttpUri().toString();
        }
        if ((path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class)) != null) {
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            uri = uri.concat(path);
        }
        return uri;
    }

    public static HttpMethods createMethod(Exchange exchange, HttpEndpoint endpoint, boolean hasPayload) {
        HttpMethods m;
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getQuery();
        }
        HttpMethods answer = (m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class))) != null ? m : (queryString != null ? HttpMethods.GET : (hasPayload ? HttpMethods.POST : HttpMethods.GET));
        return answer;
    }
}

