/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.impl.DefaultMessage;

public class HttpMessage
extends DefaultMessage {
    private HttpServletRequest request;
    private HttpServletResponse response;

    public HttpMessage(Exchange exchange, HttpServletRequest request, HttpServletResponse response) {
        this.setExchange(exchange);
        this.request = request;
        this.response = response;
        this.setHeader("CamelHttpServletRequest", request);
        this.setHeader("CamelHttpServletResponse", response);
        Boolean flag = (Boolean)exchange.getProperty("CamelSkipWwwFormUrlEncoding", Boolean.class);
        if (flag != null && flag.booleanValue()) {
            this.setHeader("CamelSkipWwwFormUrlEncoding", Boolean.TRUE);
        }
        this.getEndpoint().getBinding().readRequest(request, this);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    protected Object createBody() {
        try {
            return this.getEndpoint().getBinding().parseBody(this);
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private HttpEndpoint getEndpoint() {
        return (HttpEndpoint)this.getExchange().getFromEndpoint();
    }
}

