/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpHeaderFilterStrategy;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.component.http.helper.CamelFileDataSource;
import org.apache.camel.component.http.helper.HttpHelper;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.GZIPHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpBinding
implements HttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpBinding.class);
    private boolean useReaderForPayload;
    private boolean eagerCheckContentAvailable;
    private boolean allowJavaSerializedObject;
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    private HttpEndpoint endpoint;

    @Deprecated
    public DefaultHttpBinding() {
    }

    @Deprecated
    public DefaultHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public DefaultHttpBinding(HttpEndpoint endpoint) {
        this.endpoint = endpoint;
        this.headerFilterStrategy = endpoint.getHeaderFilterStrategy();
        if (endpoint.getComponent() != null) {
            this.allowJavaSerializedObject = endpoint.getComponent().isAllowJavaSerializedObject();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void readRequest(HttpServletRequest request, HttpMessage message) {
        DefaultHttpBinding.LOG.trace("readRequest {}", (Object)request);
        message.getBody();
        headers = message.getHeaders();
        names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = request.getHeader(name);
            extracted = HttpHelper.extractHttpParameterValue(value);
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, extracted, message.getExchange())) continue;
            HttpHelper.appendHeader(headers, name, extracted);
        }
        if (request.getCharacterEncoding() != null) {
            headers.put("CamelHttpCharacterEncoding", request.getCharacterEncoding());
            message.getExchange().setProperty("CamelCharsetName", (Object)request.getCharacterEncoding());
        }
        try {
            this.populateRequestParameters(request, message);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot read request parameters due " + e.getMessage(), (Throwable)e);
        }
        body = message.getBody();
        if (body instanceof StreamCache) {
            ((StreamCache)body).reset();
        }
        headers.put("CamelHttpMethod", request.getMethod());
        headers.put("CamelHttpQuery", request.getQueryString());
        headers.put("CamelHttpUrl", request.getRequestURL().toString());
        headers.put("CamelHttpUri", request.getRequestURI());
        headers.put("CamelHttpPath", request.getPathInfo());
        headers.put("Content-Type", request.getContentType());
        if (DefaultHttpBinding.LOG.isTraceEnabled()) {
            DefaultHttpBinding.LOG.trace("HTTP method {}", (Object)request.getMethod());
            DefaultHttpBinding.LOG.trace("HTTP query {}", (Object)request.getQueryString());
            DefaultHttpBinding.LOG.trace("HTTP url {}", (Object)request.getRequestURL());
            DefaultHttpBinding.LOG.trace("HTTP uri {}", (Object)request.getRequestURI().toString());
            DefaultHttpBinding.LOG.trace("HTTP path {}", (Object)request.getPathInfo());
            DefaultHttpBinding.LOG.trace("HTTP content-type {}", (Object)request.getContentType());
        }
        if (request.getContentType() != null && "application/x-java-serialized-object".equals(request.getContentType())) {
            if (this.allowJavaSerializedObject || this.endpoint.isTransferException()) {
                try {
                    is = (InputStream)this.endpoint.getCamelContext().getTypeConverter().mandatoryConvertTo(InputStream.class, body);
                    object = HttpHelper.deserializeJavaObjectFromStream(is);
                    if (object == null) ** GOTO lbl57
                    message.setBody(object);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Cannot deserialize body to Java object", (Throwable)e);
                }
            } else {
                message.setBody(null);
            }
        }
lbl57:
        // 5 sources

        this.populateAttachments(request, message);
    }

    protected void populateRequestParameters(HttpServletRequest request, HttpMessage message) throws Exception {
        boolean skipWwwFormUrlEncoding;
        Map headers = message.getHeaders();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            LOG.trace("HTTP parameter {} = {}", (Object)name, (Object)values);
            if (values == null) continue;
            for (String value : values) {
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                HttpHelper.appendHeader(headers, name, value);
            }
        }
        LOG.trace("HTTP method {} with Content-Type {}", (Object)request.getMethod(), (Object)request.getContentType());
        Boolean flag = (Boolean)message.getHeader("CamelSkipWwwFormUrlEncoding", Boolean.class);
        boolean bl = skipWwwFormUrlEncoding = flag != null ? flag : false;
        if (request.getMethod().equals("POST") && request.getContentType() != null && request.getContentType().startsWith("application/x-www-form-urlencoded") && !skipWwwFormUrlEncoding) {
            String body;
            String charset = request.getCharacterEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            if (ObjectHelper.isNotEmpty((Object)(body = (String)message.getBody(String.class)))) {
                for (String param : body.split("&")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length == 2) {
                        String name = URLDecoder.decode(pair[0], charset);
                        String value = URLDecoder.decode(pair[1], charset);
                        if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, message.getExchange())) continue;
                        HttpHelper.appendHeader(headers, name, value);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
                }
            }
        }
    }

    protected void populateAttachments(HttpServletRequest request, HttpMessage message) {
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object object = request.getAttribute(name);
            LOG.trace("HTTP attachment {} = {}", (Object)name, object);
            if (!(object instanceof File)) continue;
            String fileName = request.getParameter(name);
            message.addAttachment(fileName, new DataHandler((DataSource)new CamelFileDataSource((File)object, fileName)));
        }
    }

    @Override
    public void writeResponse(Exchange exchange, HttpServletResponse response) throws IOException {
        Message target;
        Message message = target = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        if (exchange.isFailed()) {
            if (exchange.getException() != null) {
                this.doWriteExceptionResponse(exchange.getException(), response);
            } else {
                this.doWriteFaultResponse(target, response, exchange);
            }
        } else {
            if (exchange.hasOut()) {
                this.copyProtocolHeaders(exchange.getIn(), exchange.getOut());
            }
            this.doWriteResponse(target, response, exchange);
        }
    }

    private void copyProtocolHeaders(Message request, Message response) {
        if (request.getHeader("Content-Encoding") != null) {
            String contentEncoding = (String)request.getHeader("Content-Encoding", String.class);
            response.setHeader("Content-Encoding", (Object)contentEncoding);
        }
        if (this.checkChunked(response, response.getExchange())) {
            response.setHeader("Transfer-Encoding", (Object)"chunked");
        }
    }

    @Override
    public void doWriteExceptionResponse(Throwable exception, HttpServletResponse response) throws IOException {
        response.setStatus(500);
        if (this.endpoint != null && this.endpoint.isTransferException()) {
            HttpHelper.writeObjectToServletResponse((ServletResponse)response, exception);
        } else {
            response.setContentType("text/plain");
            PrintWriter pw = response.getWriter();
            exception.printStackTrace(pw);
            pw.flush();
        }
    }

    @Override
    public void doWriteFaultResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        message.setHeader("CamelHttpResponseCode", (Object)500);
        this.doWriteResponse(message, response, exchange);
    }

    @Override
    public void doWriteResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        String contentType;
        if (message.getHeader("CamelHttpResponseCode") != null) {
            int code = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
            response.setStatus(code);
        }
        if ((contentType = MessageHelper.getContentType((Message)message)) != null) {
            response.setContentType(contentType);
        }
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = (String)exchange.getContext().getTypeConverter().convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, exchange)) continue;
                response.addHeader(key, headerValue);
            }
        }
        if (message.getBody() != null) {
            if (GZIPHelper.isGzip((Message)message)) {
                this.doWriteGZIPResponse(message, response, exchange);
            } else {
                this.doWriteDirectResponse(message, response, exchange);
            }
        }
    }

    protected boolean isText(String contentType) {
        String temp;
        return contentType != null && ((temp = contentType.toLowerCase()).indexOf("text") >= 0 || temp.indexOf("html") >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int copyStream(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int n;
        try {
            n = IOHelper.copy((InputStream)is, (OutputStream)os, (int)bufferSize, (boolean)true);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{os, is});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{os, is});
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteDirectResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        block19: {
            block20: {
                ServletOutputStream os;
                InputStream is;
                block21: {
                    block18: {
                        String contentType = (String)message.getHeader("Content-Type", String.class);
                        if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
                            if (this.allowJavaSerializedObject || this.endpoint.isTransferException()) {
                                try {
                                    Object object = message.getMandatoryBody(Serializable.class);
                                    HttpHelper.writeObjectToServletResponse((ServletResponse)response, object);
                                    return;
                                }
                                catch (InvalidPayloadException e) {
                                    throw new IOException(e);
                                }
                            }
                            throw new RuntimeCamelException("Content-type application/x-java-serialized-object is not allowed");
                        }
                        is = null;
                        if (this.checkChunked(message, exchange)) {
                            is = (InputStream)message.getBody(InputStream.class);
                        } else if (!this.isText(contentType)) {
                            is = (InputStream)exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, message.getBody());
                        }
                        if (is == null) break block20;
                        os = response.getOutputStream();
                        if (this.checkChunked(message, exchange)) break block21;
                        CachedOutputStream stream = new CachedOutputStream(exchange);
                        try {
                            int len = this.copyStream(is, (OutputStream)stream, response.getBufferSize());
                            response.setContentLength(len);
                            OutputStream current = stream.getCurrentStream();
                            if (current instanceof ByteArrayOutputStream) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Streaming (direct) response in non-chunked mode with content-length {}");
                                }
                                ByteArrayOutputStream bos = (ByteArrayOutputStream)current;
                                bos.writeTo((OutputStream)os);
                                break block18;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Streaming response in non-chunked mode with content-length {} and buffer size: {}", (Object)len, (Object)len);
                            }
                            this.copyStream(stream.getInputStream(), (OutputStream)os, len);
                        }
                        catch (Throwable throwable) {
                            IOHelper.close((Closeable[])new Closeable[]{is, os});
                            throw throwable;
                        }
                    }
                    IOHelper.close((Closeable[])new Closeable[]{is, os});
                    break block19;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Streaming response in chunked mode with buffer size {}", (Object)response.getBufferSize());
                }
                this.copyStream(is, (OutputStream)os, response.getBufferSize());
                break block19;
            }
            String data = (String)message.getBody(String.class);
            if (data != null) {
                String charset = IOHelper.getCharsetName((Exchange)exchange, (boolean)true);
                int dataByteLength = data.getBytes(charset).length;
                response.setCharacterEncoding(charset);
                response.setContentLength(dataByteLength);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Writing response in non-chunked mode as plain text with content-length {} and buffer size: {}", (Object)dataByteLength, (Object)response.getBufferSize());
                }
                try {
                    response.getWriter().print(data);
                }
                finally {
                    response.getWriter().flush();
                }
            }
        }
    }

    protected boolean checkChunked(Message message, Exchange exchange) {
        boolean answer = true;
        if (message.getHeader("CamelHttpChunked") == null) {
            Endpoint endpoint = exchange.getFromEndpoint();
            if (endpoint instanceof HttpEndpoint) {
                answer = ((HttpEndpoint)endpoint).isChunked();
            }
        } else {
            answer = (Boolean)message.getHeader("CamelHttpChunked", Boolean.TYPE);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteGZIPResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        byte[] bytes;
        try {
            bytes = (byte[])message.getMandatoryBody(byte[].class);
        }
        catch (InvalidPayloadException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        byte[] data = GZIPHelper.compressGZIP((byte[])bytes);
        ServletOutputStream os = response.getOutputStream();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Streaming response as GZIP in non-chunked mode with content-length {} and buffer size: {}", (Object)data.length, (Object)response.getBufferSize());
            }
            response.setContentLength(data.length);
            os.write(data);
            os.flush();
        }
        finally {
            IOHelper.close((Closeable)os);
        }
    }

    @Override
    public Object parseBody(HttpMessage httpMessage) throws IOException {
        ServletInputStream is;
        HttpServletRequest request = httpMessage.getRequest();
        int len = request.getContentLength();
        LOG.trace("HttpServletRequest content-length: {}", (Object)len);
        if (len == 0) {
            return null;
        }
        if (this.isUseReaderForPayload()) {
            return request.getReader();
        }
        if (len < 0 && this.isEagerCheckContentAvailable() && (is = request.getInputStream()).available() == 0) {
            return null;
        }
        return HttpHelper.readRequestBodyFromServletRequest(request, httpMessage.getExchange());
    }

    @Override
    public boolean isUseReaderForPayload() {
        return this.useReaderForPayload;
    }

    @Override
    public void setUseReaderForPayload(boolean useReaderForPayload) {
        this.useReaderForPayload = useReaderForPayload;
    }

    @Override
    public boolean isEagerCheckContentAvailable() {
        return this.eagerCheckContentAvailable;
    }

    @Override
    public void setEagerCheckContentAvailable(boolean eagerCheckContentAvailable) {
        this.eagerCheckContentAvailable = eagerCheckContentAvailable;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    @Override
    public boolean isAllowJavaSerializedObject() {
        return this.allowJavaSerializedObject;
    }

    @Override
    public void setAllowJavaSerializedObject(boolean allowJavaSerializedObject) {
        this.allowJavaSerializedObject = allowJavaSerializedObject;
    }
}

