/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Service;
import org.apache.camel.component.http.AuthMethod;
import org.apache.camel.component.http.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.CompositeHttpConfigurer;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.NTLMAuthenticationHttpClientConfigurer;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpConfiguration;
import org.apache.camel.http.common.HttpRestHeaderFilterStrategy;
import org.apache.camel.http.common.UrlRewrite;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public class HttpComponent
extends HttpCommonComponent
implements RestProducerFactory {
    protected HttpClientConfigurer httpClientConfigurer;
    protected HttpConnectionManager httpConnectionManager;

    public HttpComponent() {
        super(HttpEndpoint.class);
    }

    public HttpComponent(Class<? extends HttpEndpoint> endpointClass) {
        super(endpointClass);
    }

    protected HttpClientConfigurer createHttpClientConfigurer(Map<String, Object> parameters, Set<AuthMethod> authMethods) {
        HttpClientConfigurer configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class);
        if (configurer == null) {
            configurer = this.getHttpClientConfigurer();
        }
        String authUsername = (String)this.getAndRemoveParameter(parameters, "authUsername", String.class);
        String authMethod = (String)this.getAndRemoveParameter(parameters, "authMethod", String.class);
        if (authUsername != null && authMethod == null) {
            throw new IllegalArgumentException("Option authMethod must be provided to use authentication");
        }
        if (authMethod != null) {
            String authPassword = (String)this.getAndRemoveParameter(parameters, "authPassword", String.class);
            String authDomain = (String)this.getAndRemoveParameter(parameters, "authDomain", String.class);
            String authHost = (String)this.getAndRemoveParameter(parameters, "authHost", String.class);
            configurer = this.configureAuth(configurer, authMethod, authUsername, authPassword, authDomain, authHost, authMethods);
        } else if (this.httpConfiguration != null) {
            configurer = this.configureAuth(configurer, this.httpConfiguration.getAuthMethod(), this.httpConfiguration.getAuthUsername(), this.httpConfiguration.getAuthPassword(), this.httpConfiguration.getAuthDomain(), this.httpConfiguration.getAuthHost(), authMethods);
        }
        String proxyAuthUsername = (String)this.getAndRemoveParameter(parameters, "proxyAuthUsername", String.class);
        String proxyAuthMethod = (String)this.getAndRemoveParameter(parameters, "proxyAuthMethod", String.class);
        if (proxyAuthUsername != null && proxyAuthMethod == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        if (proxyAuthMethod != null) {
            String proxyAuthPassword = (String)this.getAndRemoveParameter(parameters, "proxyAuthPassword", String.class);
            String proxyAuthDomain = (String)this.getAndRemoveParameter(parameters, "proxyAuthDomain", String.class);
            String proxyAuthHost = (String)this.getAndRemoveParameter(parameters, "proxyAuthHost", String.class);
            configurer = this.configureProxyAuth(configurer, proxyAuthMethod, proxyAuthUsername, proxyAuthPassword, proxyAuthDomain, proxyAuthHost, authMethods);
        } else if (this.httpConfiguration != null) {
            configurer = this.configureProxyAuth(configurer, this.httpConfiguration.getProxyAuthMethod(), this.httpConfiguration.getProxyAuthUsername(), this.httpConfiguration.getProxyAuthPassword(), this.httpConfiguration.getProxyAuthDomain(), this.httpConfiguration.getProxyAuthHost(), authMethods);
        }
        return configurer;
    }

    protected HttpClientConfigurer configureAuth(HttpClientConfigurer configurer, String authMethod, String username, String password, String domain, String host, Set<AuthMethod> authMethods) {
        if (username == null && authMethod == null) {
            return configurer;
        }
        if (username != null && authMethod == null) {
            throw new IllegalArgumentException("Option authMethod must be provided to use authentication");
        }
        ObjectHelper.notNull((Object)authMethod, (String)"authMethod");
        ObjectHelper.notNull((Object)username, (String)"authUsername");
        ObjectHelper.notNull((Object)password, (String)"authPassword");
        AuthMethod auth = (AuthMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthMethod.class, (Object)authMethod));
        authMethods.add(auth);
        if (auth == AuthMethod.Basic || auth == AuthMethod.Digest) {
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(false, username, password));
        }
        if (auth == AuthMethod.NTLM) {
            ObjectHelper.notNull((Object)domain, (String)"authDomain");
            return CompositeHttpConfigurer.combineConfigurers(configurer, new NTLMAuthenticationHttpClientConfigurer(false, username, password, domain, host));
        }
        throw new IllegalArgumentException("Unknown authMethod " + authMethod);
    }

    protected HttpClientConfigurer configureProxyAuth(HttpClientConfigurer configurer, String authMethod, String username, String password, String domain, String host, Set<AuthMethod> authMethods) {
        if (username == null && authMethod == null) {
            return configurer;
        }
        if (username != null && authMethod == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        ObjectHelper.notNull((Object)authMethod, (String)"proxyAuthMethod");
        ObjectHelper.notNull((Object)username, (String)"proxyAuthUsername");
        ObjectHelper.notNull((Object)password, (String)"proxyAuthPassword");
        AuthMethod auth = (AuthMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthMethod.class, (Object)authMethod));
        authMethods.add(auth);
        if (auth == AuthMethod.Basic || auth == AuthMethod.Digest) {
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(true, username, password));
        }
        if (auth == AuthMethod.NTLM) {
            ObjectHelper.notNull((Object)domain, (String)"proxyAuthDomain");
            return CompositeHttpConfigurer.combineConfigurers(configurer, new NTLMAuthenticationHttpClientConfigurer(true, username, password, domain, host));
        }
        throw new IllegalArgumentException("Unknown proxyAuthMethod " + authMethod);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String addressUri = "http://" + remaining;
        if (uri.startsWith("https:")) {
            addressUri = "https://" + remaining;
        }
        HashMap<String, Object> httpClientParameters = new HashMap<String, Object>(parameters);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        String proxyHost = (String)this.getAndRemoveParameter(parameters, "proxyHost", String.class);
        Integer proxyPort = (Integer)this.getAndRemoveParameter(parameters, "proxyPort", Integer.class);
        String authMethodPriority = (String)this.getAndRemoveParameter(parameters, "authMethodPriority", String.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        UrlRewrite urlRewrite = (UrlRewrite)this.resolveAndRemoveReferenceParameter(parameters, "urlRewrite", UrlRewrite.class);
        HttpClientParams clientParams = new HttpClientParams();
        Map httpClientOptions = IntrospectionSupport.extractProperties(parameters, (String)"httpClient.");
        IntrospectionSupport.setProperties((Object)clientParams, (Map)httpClientOptions);
        this.validateParameters(uri, httpClientOptions, null);
        HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
        Map httpConnectionManagerOptions = IntrospectionSupport.extractProperties(parameters, (String)"httpConnectionManager.");
        IntrospectionSupport.setProperties((Object)connectionManagerParams, (Map)httpConnectionManagerOptions);
        this.validateParameters(uri, httpConnectionManagerOptions, null);
        HttpConnectionManager thisHttpConnectionManager = this.httpConnectionManager;
        if (thisHttpConnectionManager == null) {
            thisHttpConnectionManager = new MultiThreadedHttpConnectionManager();
            thisHttpConnectionManager.setParams(connectionManagerParams);
        }
        LinkedHashSet<AuthMethod> authMethods = new LinkedHashSet<AuthMethod>();
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, authMethods);
        addressUri = UnsafeUriCharactersEncoder.encodeHttpURI((String)addressUri);
        URI endpointUri = URISupport.createRemainingURI((URI)new URI(addressUri), httpClientParameters);
        HttpEndpoint endpoint = this.createHttpEndpoint(endpointUri.toString(), this, clientParams, thisHttpConnectionManager, configurer);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        if (urlRewrite != null) {
            this.getCamelContext().addService((Object)urlRewrite);
            endpoint.setUrlRewrite(urlRewrite);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setBinding(binding);
        }
        if (proxyHost != null) {
            endpoint.setProxyHost(proxyHost);
            endpoint.setProxyPort(proxyPort);
        } else if (this.httpConfiguration != null) {
            endpoint.setProxyHost(this.httpConfiguration.getProxyHost());
            endpoint.setProxyPort(this.httpConfiguration.getProxyPort());
        }
        if (authMethodPriority != null) {
            endpoint.setAuthMethodPriority(authMethodPriority);
        } else if (this.httpConfiguration != null && this.httpConfiguration.getAuthMethodPriority() != null) {
            endpoint.setAuthMethodPriority(this.httpConfiguration.getAuthMethodPriority());
        } else if (!authMethods.isEmpty()) {
            authMethodPriority = CollectionHelper.collectionAsCommaDelimitedString(authMethods);
            endpoint.setAuthMethodPriority(authMethodPriority);
        }
        this.setProperties((Object)endpoint, parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(addressUri), parameters);
        String part = httpUri.getSchemeSpecificPart();
        if (part != null && ((part = part.toLowerCase()).startsWith("//http//") || part.startsWith("//https//") || part.startsWith("//http://") || part.startsWith("//https://"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        endpoint.setHttpUri(httpUri);
        endpoint.setHttpClientOptions(httpClientOptions);
        return endpoint;
    }

    protected HttpEndpoint createHttpEndpoint(String uri, HttpComponent component, HttpClientParams clientParams, HttpConnectionManager connectionManager, HttpClientConfigurer configurer) throws URISyntaxException {
        return new HttpEndpoint(uri, component, clientParams, connectionManager, configurer);
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, Map<String, Object> parameters) throws Exception {
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        String url = (uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate)) != null ? String.format("%s/%s/%s", host, basePath, uriTemplate) : String.format("%s/%s", host, basePath);
        HttpEndpoint endpoint = (HttpEndpoint)camelContext.getEndpoint(url, HttpEndpoint.class);
        if (parameters != null && !parameters.isEmpty()) {
            this.setProperties(camelContext, (Object)endpoint, parameters);
        }
        String path = uriTemplate != null ? uriTemplate : basePath;
        endpoint.setHeaderFilterStrategy((HeaderFilterStrategy)new HttpRestHeaderFilterStrategy(path, queryParameters));
        ServiceHelper.startService((Service)endpoint);
        return endpoint.createProducer();
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public void setHttpBinding(HttpBinding httpBinding) {
        super.setHttpBinding(httpBinding);
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        super.setHttpConfiguration(httpConfiguration);
    }

    public void setAllowJavaSerializedObject(boolean allowJavaSerializedObject) {
        super.setAllowJavaSerializedObject(allowJavaSerializedObject);
    }
}

