/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class SSLContextParametersSecureProtocolSocketFactory
implements SecureProtocolSocketFactory {
    protected SSLSocketFactory factory;
    protected SSLContext context;

    public SSLContextParametersSecureProtocolSocketFactory(SSLSocketFactory factory) {
        this.factory = factory;
    }

    @Deprecated
    public SSLContextParametersSecureProtocolSocketFactory(SSLContextParameters params) {
        this(params, null);
    }

    public SSLContextParametersSecureProtocolSocketFactory(SSLContextParameters params, CamelContext camelContext) {
        try {
            this.context = params.createSSLContext(camelContext);
            this.factory = this.context.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error creating the SSLContext.", (Throwable)e);
        }
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.factory.createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return this.createSocket(host, port, localAddress, localPort);
        }
        return ControllerThreadSocketFactory.createSocket((ProtocolSocketFactory)this, (String)host, (int)port, (InetAddress)localAddress, (int)localPort, (int)timeout);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.factory.createSocket(socket, host, port, autoClose);
    }
}

