/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.UnknownHostException;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.component.http.AuthMethod;
import org.apache.camel.component.http.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.CompositeHttpConfigurer;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpProxyConfigurer;
import org.apache.camel.component.http.HttpUtil;
import org.apache.camel.component.http.NTLMAuthenticationHttpClientConfigurer;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.impl.verifier.DefaultComponentVerifier;
import org.apache.camel.impl.verifier.ResultBuilder;
import org.apache.camel.impl.verifier.ResultErrorBuilder;
import org.apache.camel.impl.verifier.ResultErrorHelper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;

final class HttpComponentVerifier
extends DefaultComponentVerifier {
    private final HttpComponent component;

    HttpComponentVerifier(HttpComponent component) {
        super("http", component.getCamelContext());
        this.component = component;
    }

    protected ComponentVerifier.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.PARAMETERS);
        super.verifyParametersAgainstCatalog(builder, parameters);
        Optional authMethod = this.getOption(parameters, "authMethod", String.class);
        if (authMethod.isPresent()) {
            builder.error(ResultErrorHelper.requiresOption((String)"authUsername", parameters));
            builder.error(ResultErrorHelper.requiresOption((String)"authPassword", parameters));
            AuthMethod auth = (AuthMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthMethod.class, authMethod.get()));
            if (auth != AuthMethod.Basic && auth != AuthMethod.Digest && auth != AuthMethod.NTLM) {
                builder.error(ResultErrorBuilder.withIllegalOption((String)"authMethod", (String)((String)authMethod.get())).build());
            }
            if (auth == AuthMethod.NTLM) {
                builder.error(ResultErrorHelper.requiresOption((String)"authDomain", parameters));
            }
        }
        return builder.build();
    }

    protected ComponentVerifier.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.CONNECTIVITY);
        Optional uri = this.getOption(parameters, "httpUri", String.class);
        if (!uri.isPresent()) {
            builder.error(ResultErrorHelper.requiresOption((String)"httpUri", parameters));
        } else {
            builder.error(parameters, this::verifyHttpConnectivity);
        }
        return builder.build();
    }

    private void verifyHttpConnectivity(ResultBuilder builder, Map<String, Object> parameters) throws Exception {
        Optional uri = this.getOption(parameters, "httpUri", String.class);
        HttpClient httpclient = this.createHttpClient(builder, parameters);
        GetMethod method = new GetMethod((String)uri.get());
        try {
            int code = httpclient.executeMethod((HttpMethod)method);
            String okCodes = this.getOption(parameters, "okStatusCodeRange", String.class).orElse("200-299");
            if (!HttpHelper.isStatusCodeOk((int)code, (String)okCodes)) {
                if (code == 401) {
                    builder.error(ResultErrorBuilder.withHttpCode((int)code).description(method.getStatusText()).parameterKey("authUsername").parameterKey("authPassword").build());
                } else if (code >= 300 && code < 400) {
                    builder.error(ResultErrorBuilder.withHttpCode((int)code).description(method.getStatusText()).parameterKey("httpUri").detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.HttpAttribute.HTTP_REDIRECT, () -> HttpComponentVerifier.lambda$verifyHttpConnectivity$0((HttpMethod)method)).build());
                } else if (code >= 400) {
                    builder.error(ResultErrorBuilder.withHttpCode((int)code).description(method.getStatusText()).build());
                }
            }
        }
        catch (UnknownHostException e) {
            builder.error(ResultErrorBuilder.withException((Exception)e).parameterKey("httpUri").build());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<HttpClientConfigurer> configureAuthentication(ResultBuilder builder, Map<String, Object> parameters) {
        Optional authMethod = this.getOption(parameters, "authMethod", String.class);
        if (!authMethod.isPresent()) return Optional.empty();
        Optional authUsername = this.getOption(parameters, "authUsername", String.class);
        Optional authPassword = this.getOption(parameters, "authPassword", String.class);
        if (authUsername.isPresent() && authUsername.isPresent()) {
            AuthMethod auth = (AuthMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthMethod.class, authMethod.get()));
            if (auth == AuthMethod.Basic || auth == AuthMethod.Digest) {
                return Optional.of(new BasicAuthenticationHttpClientConfigurer(false, (String)authUsername.get(), (String)authPassword.get()));
            }
            if (auth == AuthMethod.NTLM) {
                Optional authDomain = this.getOption(parameters, "authDomain", String.class);
                Optional authHost = this.getOption(parameters, "authHost", String.class);
                if (authDomain.isPresent()) return Optional.of(new NTLMAuthenticationHttpClientConfigurer(false, (String)authUsername.get(), (String)authPassword.get(), (String)authDomain.get(), authHost.orElse(null)));
                builder.error(ResultErrorBuilder.withMissingOption((String)"authDomain").build());
                return Optional.empty();
            } else {
                builder.error(ResultErrorBuilder.withIllegalOption((String)"authMethod", (String)((String)authMethod.get())).build());
            }
            return Optional.empty();
        } else {
            builder.error(ResultErrorHelper.requiresOption((String)"authUsername", parameters));
            builder.error(ResultErrorHelper.requiresOption((String)"authPassword", parameters));
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<HttpClientConfigurer> configureProxy(ResultBuilder builder, Map<String, Object> parameters) {
        Optional authMethod;
        Optional proxyPort;
        CompositeHttpConfigurer configurer = new CompositeHttpConfigurer();
        Optional proxyHost = this.getOption(parameters, "proxyAuthHost", String.class);
        if (!proxyHost.isPresent()) {
            proxyHost = this.getOption(parameters, "proxyHost", String.class);
        }
        if (!(proxyPort = this.getOption(parameters, "proxyAuthPort", Integer.class)).isPresent()) {
            proxyPort = this.getOption(parameters, "proxyPort", Integer.class);
        }
        if (proxyHost.isPresent() || proxyPort.isPresent()) {
            configurer.addConfigurer(new HttpProxyConfigurer(proxyHost, proxyPort));
        }
        if (!(authMethod = this.getOption(parameters, "proxyAuthMethod", String.class)).isPresent()) return Optional.of(configurer);
        Optional authUsername = this.getOption(parameters, "proxyAuthUsername", String.class);
        Optional authPassword = this.getOption(parameters, "proxyAuthPassword", String.class);
        if (authUsername.isPresent() && authUsername.isPresent()) {
            AuthMethod auth = (AuthMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthMethod.class, (Object)authMethod));
            if (auth == AuthMethod.Basic || auth == AuthMethod.Digest) {
                configurer.addConfigurer(new BasicAuthenticationHttpClientConfigurer(false, (String)authUsername.get(), (String)authPassword.get()));
                return Optional.of(configurer);
            } else if (auth == AuthMethod.NTLM) {
                Optional authDomain = this.getOption(parameters, "proxyAuthDomain", String.class);
                Optional authHost = this.getOption(parameters, "proxyAuthHost", String.class);
                if (authDomain.isPresent()) return Optional.of(new NTLMAuthenticationHttpClientConfigurer(false, (String)authUsername.get(), (String)authPassword.get(), (String)authDomain.get(), authHost.orElse(null)));
                builder.error(ResultErrorBuilder.withMissingOption((String)"authDomain").build());
                return Optional.of(configurer);
            } else {
                builder.error(ResultErrorBuilder.withIllegalOption((String)"authMethod", (String)((String)authMethod.get())).build());
            }
            return Optional.of(configurer);
        } else {
            builder.error(ResultErrorHelper.requiresOption((String)"authUsername", parameters));
            builder.error(ResultErrorHelper.requiresOption((String)"authPassword", parameters));
        }
        return Optional.of(configurer);
    }

    private HttpClient createHttpClient(ResultBuilder builder, Map<String, Object> parameters) throws Exception {
        HttpClientParams clientParams = (HttpClientParams)this.setProperties(new HttpClientParams(), "httpClient.", parameters);
        HttpClient client = new HttpClient(clientParams);
        CompositeHttpConfigurer configurer = new CompositeHttpConfigurer();
        this.configureProxy(builder, parameters).ifPresent(configurer::addConfigurer);
        this.configureAuthentication(builder, parameters).ifPresent(configurer::addConfigurer);
        configurer.configureHttpClient(client);
        return client;
    }

    private static /* synthetic */ Optional lambda$verifyHttpConnectivity$0(HttpMethod method) {
        return HttpUtil.responseHeaderValue(method, "location");
    }
}

