/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HttpMethods implements Expression
{
    GET(GetMethod.class),
    POST(PostMethod.class),
    PUT(PutMethod.class),
    DELETE(DeleteMethod.class),
    HEAD(HeadMethod.class),
    OPTIONS(OptionsMethod.class),
    TRACE(TraceMethod.class);

    final Class<? extends HttpMethod> clazz;
    final boolean entity;

    private HttpMethods(Class<? extends HttpMethod> clazz) {
        this.clazz = clazz;
        this.entity = EntityEnclosingMethod.class.isAssignableFrom(clazz);
    }

    public HttpMethod createMethod(String url) {
        try {
            return this.clazz.getDeclaredConstructor(String.class).newInstance(url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean isEntityEnclosing() {
        return this.entity;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        return (T)ExpressionBuilder.constantExpression((Object)this.name()).evaluate(exchange, type);
    }
}

