/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.http.helper.GZIPHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;

@Converter
public class RequestEntityConverter {
    @Converter
    public RequestEntity toRequestEntity(byte[] data, Exchange exchange) throws Exception {
        return this.asRequestEntity(data, exchange);
    }

    @Converter
    public RequestEntity toRequestEntity(InputStream inStream, Exchange exchange) throws Exception {
        return this.asRequestEntity(inStream, exchange);
    }

    @Converter
    public RequestEntity toRequestEntity(String str, Exchange exchange) throws Exception {
        if (GZIPHelper.isGzip(exchange.getIn())) {
            byte[] data = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, (Object)str);
            return this.asRequestEntity(data, exchange);
        }
        return null;
    }

    private RequestEntity asRequestEntity(InputStream in, Exchange exchange) throws IOException {
        if (exchange != null && !((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return new InputStreamRequestEntity(GZIPHelper.compressGzip((String)exchange.getIn().getHeader("Content-Encoding", String.class), in), ExchangeHelper.getContentType((Exchange)exchange));
        }
        return new InputStreamRequestEntity(in);
    }

    private RequestEntity asRequestEntity(byte[] data, Exchange exchange) throws Exception {
        if (exchange != null && !((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return new InputStreamRequestEntity(GZIPHelper.compressGzip((String)exchange.getIn().getHeader("Content-Encoding", String.class), data), ExchangeHelper.getContentType((Exchange)exchange));
        }
        return new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(data));
    }
}

