/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.GZIPHelper;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;

@Converter
public final class RequestEntityConverter {
    private RequestEntityConverter() {
    }

    @Converter
    public static RequestEntity toRequestEntity(byte[] data, Exchange exchange) throws Exception {
        return RequestEntityConverter.asRequestEntity(data, exchange);
    }

    @Converter
    public static RequestEntity toRequestEntity(InputStream inStream, Exchange exchange) throws Exception {
        return RequestEntityConverter.asRequestEntity(inStream, exchange);
    }

    @Converter
    public static RequestEntity toRequestEntity(String str, Exchange exchange) throws Exception {
        if (GZIPHelper.isGzip((Message)exchange.getIn())) {
            byte[] data = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, (Object)str);
            return RequestEntityConverter.asRequestEntity(data, exchange);
        }
        return null;
    }

    private static RequestEntity asRequestEntity(InputStream in, Exchange exchange) throws IOException {
        if (exchange != null && !((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return new InputStreamRequestEntity(GZIPHelper.compressGzip((String)((String)exchange.getIn().getHeader("Content-Encoding", String.class)), (InputStream)in), ExchangeHelper.getContentType((Exchange)exchange));
        }
        if (exchange != null) {
            return new InputStreamRequestEntity(in, ExchangeHelper.getContentType((Exchange)exchange));
        }
        return new InputStreamRequestEntity(in);
    }

    private static RequestEntity asRequestEntity(byte[] data, Exchange exchange) throws Exception {
        if (exchange != null && !((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return new InputStreamRequestEntity(GZIPHelper.compressGzip((String)((String)exchange.getIn().getHeader("Content-Encoding", String.class)), (byte[])data), ExchangeHelper.getContentType((Exchange)exchange));
        }
        if (exchange != null) {
            return new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(data), ExchangeHelper.getContentType((Exchange)exchange));
        }
        return new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(data));
    }
}

