/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.helper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.http.HttpConverter;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class HttpHelper {
    private HttpHelper() {
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        int index;
        if (contentType != null && (index = contentType.indexOf("charset=")) > 0) {
            String charset = contentType.substring(index + 8);
            exchange.setProperty("CamelCharsetName", (Object)IOConverter.normalizeCharset((String)charset));
        }
    }

    public static void writeObjectToServletResponse(ServletResponse response, Object target) throws IOException {
        response.setContentType("application/x-java-serialized-object");
        HttpHelper.writeObjectToStream((OutputStream)response.getOutputStream(), target);
    }

    public static void writeObjectToStream(OutputStream stream, Object target) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(target);
        oos.flush();
        IOHelper.close((Closeable)oos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        if (is == null) {
            return null;
        }
        Object answer = null;
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static Object readResponseBodyFromServletRequest(HttpServletRequest request, Exchange exchange) throws IOException {
        InputStream is = HttpConverter.toInputStream(request, exchange);
        return HttpHelper.readResponseBodyFromInputStream(is, exchange);
    }

    public static Object readResponseBodyFromInputStream(InputStream is, Exchange exchange) throws IOException {
        if (is == null) {
            return null;
        }
        if (((Boolean)exchange.getProperty("CamelDisableHttpStreamCache", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return is;
        }
        CachedOutputStream cos = new CachedOutputStream(exchange);
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)cos);
        return cos.getStreamCache();
    }

    public static String createURL(Exchange exchange, HttpEndpoint endpoint) {
        String uri = null;
        if (!endpoint.isBridgeEndpoint()) {
            uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        }
        if (uri == null) {
            uri = endpoint.getHttpUri().toASCIIString();
        }
        try {
            uri = exchange.getContext().resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uri, exchange, (Throwable)e);
        }
        String path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        if (path != null) {
            block13: {
                if (path.startsWith("/")) {
                    String baseURIString = (String)exchange.getIn().getHeader("CamelHttpBaseUri", String.class);
                    try {
                        URI baseURI;
                        String basePath;
                        if (baseURIString == null) {
                            baseURIString = exchange.getFromEndpoint() != null ? exchange.getFromEndpoint().getEndpointUri() : "/";
                        }
                        if (path.startsWith(basePath = (baseURI = new URI(baseURIString)).getPath())) {
                            if ((path = path.substring(basePath.length())).startsWith("/")) {
                                path = path.substring(1);
                            }
                            break block13;
                        }
                        throw new RuntimeExchangeException("Cannot analyze the Exchange.HTTP_PATH header, due to: cannot find the right HTTP_BASE_URI", exchange);
                    }
                    catch (Throwable t) {
                        throw new RuntimeExchangeException("Cannot analyze the Exchange.HTTP_PATH header, due to: " + t.getMessage(), exchange, t);
                    }
                }
            }
            if (path.length() > 0) {
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                }
                uri = uri.concat(path);
            }
        }
        uri = UnsafeUriCharactersEncoder.encode((String)uri);
        return uri;
    }

    public static HttpMethods createMethod(Exchange exchange, HttpEndpoint endpoint, boolean hasPayload) throws URISyntaxException {
        HttpMethods m;
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        String uriString = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        try {
            uriString = exchange.getContext().resolvePropertyPlaceholders(uriString);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uriString, exchange, (Throwable)e);
        }
        if (uriString != null) {
            URI uri = new URI(uriString);
            queryString = uri.getQuery();
        }
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getQuery();
        }
        HttpMethods answer = (m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class))) != null ? m : (queryString != null ? HttpMethods.GET : (hasPayload ? HttpMethods.POST : HttpMethods.GET));
        return answer;
    }

    public static void appendHeader(Map headers, String key, Object value) {
        if (headers.containsKey(key)) {
            ArrayList<Object> list;
            Object existing = headers.get(key);
            if (existing instanceof List) {
                list = (ArrayList<Object>)existing;
            } else {
                list = new ArrayList<Object>();
                list.add(existing);
            }
            list.add(value);
            value = list;
        }
        headers.put(key, value);
    }

    public static Object extractHttpParameterValue(String value) {
        if (value == null || ObjectHelper.isEmpty((Object)value)) {
            return value;
        }
        String trimmed = value.trim();
        if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
            String[] values;
            trimmed = trimmed.substring(1, trimmed.length() - 1);
            ArrayList<String> list = new ArrayList<String>();
            for (String s : values = trimmed.split(",")) {
                list.add(s.trim());
            }
            return list;
        }
        return value;
    }
}

