/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.helper;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class HttpMethodHelper {
    private HttpMethodHelper() {
    }

    public static HttpMethods createMethod(Exchange exchange, HttpEndpoint endpoint, boolean hasPayload) throws URISyntaxException {
        HttpMethods m;
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        String uriString = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        try {
            uriString = exchange.getContext().resolvePropertyPlaceholders(uriString);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uriString, exchange, (Throwable)e);
        }
        if (uriString != null) {
            uriString = UnsafeUriCharactersEncoder.encodeHttpURI((String)uriString);
            URI uri = new URI(uriString);
            queryString = uri.getQuery();
        }
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getRawQuery();
        }
        HttpMethods answer = endpoint.getHttpMethod() != null ? HttpMethods.valueOf(endpoint.getHttpMethod().name()) : ((m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class))) != null ? m : (queryString != null ? HttpMethods.GET : (hasPayload ? HttpMethods.POST : HttpMethods.GET)));
        return answer;
    }
}

