/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpPollingConsumer;
import org.apache.camel.component.http.HttpProducer;
import org.apache.camel.component.http.NoopCookieStore;
import org.apache.camel.component.http.PreemptiveAuthInterceptor;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.3.0", scheme="http,https", title="HTTP,HTTPS", syntax="http://httpUri", producerOnly=true, category={Category.HTTP}, lenientProperties=true)
@ManagedResource(description="Managed HttpEndpoint")
public class HttpEndpoint
extends HttpCommonEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEndpoint.class);
    @UriParam(label="security", description="To configure security using SSLContextParameters. Important: Only one instance of org.apache.camel.util.jsse.SSLContextParameters is supported per HttpComponent. If you need to use 2 or more different instances, you need to define a new HttpComponent per instance you need.")
    protected SSLContextParameters sslContextParameters;
    @UriParam(label="advanced", description="To use a custom HttpContext instance")
    private HttpContext httpContext;
    @UriParam(label="advanced", description="Register a custom configuration strategy for new HttpClient instances created by producers or consumers such as to configure authentication mechanisms etc.")
    private HttpClientConfigurer httpClientConfigurer;
    @UriParam(label="advanced", prefix="httpClient.", multiValue=true, description="To configure the HttpClient using the key/values from the Map.")
    private Map<String, Object> httpClientOptions;
    @UriParam(label="advanced", description="To use a custom HttpClientConnectionManager to manage connections")
    private HttpClientConnectionManager clientConnectionManager;
    @UriParam(label="advanced", description="Provide access to the http client request parameters used on new RequestConfig instances used by producers or consumers of this endpoint.")
    private HttpClientBuilder clientBuilder;
    @UriParam(label="advanced", description="Sets a custom HttpClient to be used by the producer")
    private HttpClient httpClient;
    @UriParam(label="advanced", defaultValue="false", description="To use System Properties as fallback for configuration")
    private boolean useSystemProperties;
    @Metadata(label="timeout", defaultValue="-1", description="The timeout in milliseconds used when requesting a connection from the connection manager. A timeout value of zero is interpreted as an infinite timeout. A timeout value of zero is interpreted as an infinite timeout. A negative value is interpreted as undefined (system default).", javaType="java.time.Duration")
    private long connectionRequestTimeout = -1L;
    @Metadata(label="timeout", defaultValue="-1", description="Determines the timeout in milliseconds until a connection is established. A timeout value of zero is interpreted as an infinite timeout. A timeout value of zero is interpreted as an infinite timeout. A negative value is interpreted as undefined (system default).", javaType="java.time.Duration")
    private long connectTimeout = -1L;
    @Metadata(label="timeout", defaultValue="-1", description="Defines the socket timeout in milliseconds, which is the timeout for waiting for data  or, put differently, a maximum period inactivity between two consecutive data packets). A timeout value of zero is interpreted as an infinite timeout. A negative value is interpreted as undefined (system default).", javaType="java.time.Duration")
    private long socketTimeout = -1L;
    @UriParam(label="producer,advanced", description="To use a custom CookieStore. By default the BasicCookieStore is used which is an in-memory only cookie store. Notice if bridgeEndpoint=true then the cookie store is forced to be a noop cookie store as cookie shouldn't be stored as we are just bridging (eg acting as a proxy). If a cookieHandler is set then the cookie store is also forced to be a noop cookie store as cookie handling is then performed by the cookieHandler.")
    private CookieStore cookieStore = new BasicCookieStore();
    @UriParam(label="producer", defaultValue="true", description="Whether to clear expired cookies before sending the HTTP request. This ensures the cookies store does not keep growing by adding new cookies which is newer removed when they are expired. If the component has disabled cookie management then this option is disabled too.")
    private boolean clearExpiredCookies = true;
    @UriParam(label="producer,security", description="If this option is true, camel-http sends preemptive basic authentication to the server.")
    private boolean authenticationPreemptive;
    @UriParam(label="producer,advanced", description="Whether the HTTP GET should include the message body or not. By default HTTP GET do not include any HTTP body. However in some rare cases users may need to be able to include the message body.")
    private boolean getWithBody;
    @UriParam(label="producer,advanced", description="Whether the HTTP DELETE should include the message body or not. By default HTTP DELETE do not include any HTTP body. However in some rare cases users may need to be able to include the message body.")
    private boolean deleteWithBody;
    @UriParam(label="advanced", defaultValue="200", description="The maximum number of connections.")
    private int maxTotalConnections;
    @UriParam(label="advanced", defaultValue="20", description="The maximum number of connections per route.")
    private int connectionsPerRoute;
    @UriParam(label="security", description="To use a custom X509HostnameVerifier such as DefaultHostnameVerifier or NoopHostnameVerifier")
    private HostnameVerifier x509HostnameVerifier;
    @UriParam(label="producer", description="To use custom host header for producer. When not set in query will be ignored. When set will override host header derived from url.")
    private String customHostHeader;
    @UriParam(label="producer,advanced", description="Whether to skip mapping all the Camel headers as HTTP request headers. If there are no data from Camel headers needed to be included in the HTTP request then this can avoid parsing overhead with many object allocations for the JVM garbage collector.")
    private boolean skipRequestHeaders;
    @UriParam(label="producer,advanced", description="Whether to skip mapping all the HTTP response headers to Camel headers. If there are no data needed from HTTP headers then this can avoid parsing overhead with many object allocations for the JVM garbage collector.")
    private boolean skipResponseHeaders;

    public HttpEndpoint() {
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI) throws URISyntaxException {
        this(endPointURI, component, httpURI, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientConnectionManager clientConnectionManager) throws URISyntaxException {
        this(endPointURI, component, httpURI, HttpClientBuilder.create(), clientConnectionManager, null);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, HttpClientBuilder clientBuilder, HttpClientConnectionManager clientConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        this(endPointURI, component, null, clientBuilder, clientConnectionManager, clientConfigurer);
    }

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI, HttpClientBuilder clientBuilder, HttpClientConnectionManager clientConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        super(endPointURI, (HttpCommonComponent)component, httpURI);
        this.clientBuilder = clientBuilder;
        this.httpClientConfigurer = clientConfigurer;
        this.clientConnectionManager = clientConnectionManager;
    }

    public Producer createProducer() throws Exception {
        return new HttpProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from http endpoint");
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        HttpPollingConsumer answer = new HttpPollingConsumer(this);
        this.configurePollingConsumer((PollingConsumer)answer);
        return answer;
    }

    public synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpClient createHttpClient() {
        HttpClientConfigurer configurer;
        ObjectHelper.notNull((Object)this.clientBuilder, (String)"httpClientBuilder");
        ObjectHelper.notNull((Object)this.clientConnectionManager, (String)"httpConnectionManager");
        this.clientBuilder.setDefaultCookieStore(this.cookieStore);
        this.clientBuilder.setConnectionManager(this.clientConnectionManager);
        if (this.getComponent() != null && this.getComponent().getClientConnectionManager() == this.getClientConnectionManager()) {
            this.clientBuilder.setConnectionManagerShared(true);
        }
        if (!this.useSystemProperties) {
            if (ObjectHelper.isNotEmpty((Object)this.getCamelContext().getGlobalOption("http.proxyHost")) && ObjectHelper.isNotEmpty((Object)this.getCamelContext().getGlobalOption("http.proxyPort"))) {
                String host = this.getCamelContext().getGlobalOption("http.proxyHost");
                int port = Integer.parseInt(this.getCamelContext().getGlobalOption("http.proxyPort"));
                String scheme = this.getCamelContext().getGlobalOption("http.proxyScheme");
                if (scheme == null) {
                    scheme = HttpHelper.isSecureConnection((String)this.getEndpointUri()) ? "https" : "http";
                }
                LOG.debug("CamelContext properties http.proxyHost, http.proxyPort, and http.proxyScheme detected. Using http proxy host: {} port: {} scheme: {}", new Object[]{host, port, scheme});
                HttpHost proxy = new HttpHost(host, port, scheme);
                this.clientBuilder.setProxy(proxy);
            }
        } else {
            this.clientBuilder.useSystemProperties();
        }
        if (this.isAuthenticationPreemptive()) {
            this.clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor());
        }
        if ((configurer = this.getHttpClientConfigurer()) != null) {
            configurer.configureHttpClient(this.clientBuilder);
        }
        if (this.isBridgeEndpoint()) {
            this.clientBuilder.setDefaultCookieStore((CookieStore)new NoopCookieStore());
        }
        LOG.debug("Setup the HttpClientBuilder {}", (Object)this.clientBuilder);
        return this.clientBuilder.build();
    }

    public HttpComponent getComponent() {
        return (HttpComponent)super.getComponent();
    }

    protected void doStop() throws Exception {
        if (this.getComponent() != null && this.getComponent().getClientConnectionManager() != this.clientConnectionManager) {
            this.clientConnectionManager.shutdown();
        }
        if (this.httpClient instanceof Closeable) {
            IOHelper.close((Closeable)((Closeable)this.httpClient));
        }
    }

    public HttpClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public void setClientBuilder(HttpClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public HttpClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public boolean isClearExpiredCookies() {
        return this.clearExpiredCookies;
    }

    public void setClearExpiredCookies(boolean clearExpiredCookies) {
        this.clearExpiredCookies = clearExpiredCookies;
    }

    public boolean isDeleteWithBody() {
        return this.deleteWithBody;
    }

    public void setDeleteWithBody(boolean deleteWithBody) {
        this.deleteWithBody = deleteWithBody;
    }

    public boolean isGetWithBody() {
        return this.getWithBody;
    }

    public void setGetWithBody(boolean getWithBody) {
        this.getWithBody = getWithBody;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        super.setCookieHandler(cookieHandler);
        this.cookieStore = new NoopCookieStore();
    }

    public boolean isAuthenticationPreemptive() {
        return this.authenticationPreemptive;
    }

    public void setAuthenticationPreemptive(boolean authenticationPreemptive) {
        this.authenticationPreemptive = authenticationPreemptive;
    }

    public Map<String, Object> getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public void setHttpClientOptions(Map<String, Object> httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getConnectionsPerRoute() {
        return this.connectionsPerRoute;
    }

    public void setConnectionsPerRoute(int connectionsPerRoute) {
        this.connectionsPerRoute = connectionsPerRoute;
    }

    public HostnameVerifier getX509HostnameVerifier() {
        return this.x509HostnameVerifier;
    }

    public void setX509HostnameVerifier(HostnameVerifier x509HostnameVerifier) {
        this.x509HostnameVerifier = x509HostnameVerifier;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public long getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(long connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(long socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setCustomHostHeader(String customHostHeader) {
        this.customHostHeader = customHostHeader;
    }

    public String getCustomHostHeader() {
        return this.customHostHeader;
    }

    public boolean isSkipRequestHeaders() {
        return this.skipRequestHeaders;
    }

    public void setSkipRequestHeaders(boolean skipRequestHeaders) {
        this.skipRequestHeaders = skipRequestHeaders;
    }

    public boolean isSkipResponseHeaders() {
        return this.skipResponseHeaders;
    }

    public void setSkipResponseHeaders(boolean skipResponseHeaders) {
        this.skipResponseHeaders = skipResponseHeaders;
    }

    @ManagedAttribute(description="Maximum number of allowed persistent connections")
    public int getClientConnectionsPoolStatsMax() {
        PoolStats stats;
        ConnPoolControl pool = null;
        if (this.clientConnectionManager instanceof ConnPoolControl) {
            pool = (ConnPoolControl)this.clientConnectionManager;
        }
        if (pool != null && (stats = pool.getTotalStats()) != null) {
            return stats.getMax();
        }
        return -1;
    }

    @ManagedAttribute(description="Number of available idle persistent connections")
    public int getClientConnectionsPoolStatsAvailable() {
        PoolStats stats;
        ConnPoolControl pool = null;
        if (this.clientConnectionManager instanceof ConnPoolControl) {
            pool = (ConnPoolControl)this.clientConnectionManager;
        }
        if (pool != null && (stats = pool.getTotalStats()) != null) {
            return stats.getAvailable();
        }
        return -1;
    }

    @ManagedAttribute(description="Number of persistent connections tracked by the connection manager currently being used to execute requests")
    public int getClientConnectionsPoolStatsLeased() {
        PoolStats stats;
        ConnPoolControl pool = null;
        if (this.clientConnectionManager instanceof ConnPoolControl) {
            pool = (ConnPoolControl)this.clientConnectionManager;
        }
        if (pool != null && (stats = pool.getTotalStats()) != null) {
            return stats.getLeased();
        }
        return -1;
    }

    @ManagedAttribute(description="Number of connection requests being blocked awaiting a free connection. This can happen only if there are more worker threads contending for fewer connections.")
    public int getClientConnectionsPoolStatsPending() {
        PoolStats stats;
        ConnPoolControl pool = null;
        if (this.clientConnectionManager instanceof ConnPoolControl) {
            pool = (ConnPoolControl)this.clientConnectionManager;
        }
        if (pool != null && (stats = pool.getTotalStats()) != null) {
            return stats.getPending();
        }
        return -1;
    }
}

