/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.http.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.CompositeHttpConfigurer;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpUtil;
import org.apache.camel.component.http.ProxyHttpClientConfigurer;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

final class HttpComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    HttpComponentVerifierExtension() {
        super("http");
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS);
        HashMap<String, Object> verifyParams = new HashMap<String, Object>(parameters);
        boolean isRest = verifyParams.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith("rest."));
        if (isRest) {
            verifyParams.put("httpUri", this.buildHttpUriFromRestParameters(parameters));
            verifyParams.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("rest."));
        }
        super.verifyParametersAgainstCatalog(builder, verifyParams);
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        String httpUri;
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY);
        HashMap<String, Object> verifyParams = new HashMap<String, Object>(parameters);
        boolean isRest = verifyParams.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith("rest."));
        if (isRest) {
            verifyParams.put("httpUri", this.buildHttpUriFromRestParameters(parameters));
            verifyParams.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("rest."));
        }
        if (ObjectHelper.isEmpty((String)(httpUri = (String)this.getOption(verifyParams, "httpUri", String.class).orElse(null)))) {
            builder.error(ResultErrorBuilder.withMissingOption((String)"httpUri").detail("rest", (Object)isRest).build());
        }
        try {
            CloseableHttpClient httpclient = this.createHttpClient(verifyParams);
            HttpGet request = new HttpGet(httpUri);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);){
                int code = response.getStatusLine().getStatusCode();
                String okCodes = this.getOption(verifyParams, "okStatusCodeRange", String.class).orElse("200-299");
                if (!HttpHelper.isStatusCodeOk((int)code, (String)okCodes)) {
                    if (code == 401) {
                        builder.error(ResultErrorBuilder.withHttpCode((int)code).description(response.getStatusLine().getReasonPhrase()).parameterKey("authUsername").parameterKey("authPassword").build());
                    } else if (code >= 300 && code < 400) {
                        builder.error(ResultErrorBuilder.withHttpCode((int)code).description(response.getStatusLine().getReasonPhrase()).parameterKey("httpUri").detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_REDIRECT, () -> HttpUtil.responseHeaderValue((HttpResponse)response, "location")).build());
                    } else if (code >= 400) {
                        builder.error(ResultErrorBuilder.withHttpCode((int)code).description(response.getStatusLine().getReasonPhrase()).build());
                    }
                }
            }
            catch (UnknownHostException e2) {
                builder.error(ResultErrorBuilder.withException((Exception)e2).parameterKey("httpUri").build());
            }
        }
        catch (Exception e3) {
            builder.error(ResultErrorBuilder.withException((Exception)e3).build());
        }
        return builder.build();
    }

    private String buildHttpUriFromRestParameters(Map<String, Object> parameters) {
        Object httpUri = this.getOption(parameters, "rest.host", String.class).orElse(null);
        String path = this.getOption(parameters, "rest.path", String.class).map(FileUtil::stripLeadingSeparator).orElse(null);
        if (ObjectHelper.isNotEmpty((String)httpUri) && ObjectHelper.isNotEmpty((String)path)) {
            httpUri = (String)httpUri + "/" + path;
        }
        return httpUri;
    }

    private Optional<HttpClientConfigurer> configureAuthentication(Map<String, Object> parameters) {
        Optional authUsername = this.getOption(parameters, "authUsername", String.class);
        Optional authPassword = this.getOption(parameters, "authPassword", String.class);
        if (authUsername.isPresent() && authPassword.isPresent()) {
            Optional authDomain = this.getOption(parameters, "authDomain", String.class);
            Optional authHost = this.getOption(parameters, "authHost", String.class);
            return Optional.of(new BasicAuthenticationHttpClientConfigurer((String)authUsername.get(), (String)authPassword.get(), authDomain.orElse(null), authHost.orElse(null)));
        }
        return Optional.empty();
    }

    private Optional<HttpClientConfigurer> configureProxy(Map<String, Object> parameters) {
        Optional uri = this.getOption(parameters, "httpUri", String.class);
        Optional proxyAuthHost = this.getOption(parameters, "proxyAuthHost", String.class);
        Optional proxyAuthPort = this.getOption(parameters, "proxyAuthPort", Integer.class);
        if (proxyAuthHost.isPresent() && proxyAuthPort.isPresent()) {
            Optional<String> proxyAuthScheme = this.getOption(parameters, "proxyAuthScheme", String.class);
            Optional proxyAuthUsername = this.getOption(parameters, "proxyAuthUsername", String.class);
            Optional proxyAuthPassword = this.getOption(parameters, "proxyAuthPassword", String.class);
            Optional proxyAuthDomain = this.getOption(parameters, "proxyAuthDomain", String.class);
            Optional proxyAuthNtHost = this.getOption(parameters, "proxyAuthNtHost", String.class);
            if (!proxyAuthScheme.isPresent()) {
                proxyAuthScheme = Optional.of(HttpHelper.isSecureConnection((String)((String)uri.get())) ? "https" : "http");
            }
            if (proxyAuthUsername != null && proxyAuthPassword != null) {
                return Optional.of(new ProxyHttpClientConfigurer((String)proxyAuthHost.get(), (Integer)proxyAuthPort.get(), proxyAuthScheme.get(), proxyAuthUsername.orElse(null), proxyAuthPassword.orElse(null), proxyAuthDomain.orElse(null), proxyAuthNtHost.orElse(null)));
            }
            return Optional.of(new ProxyHttpClientConfigurer((String)proxyAuthHost.get(), (Integer)proxyAuthPort.get(), proxyAuthScheme.get()));
        }
        return Optional.empty();
    }

    private CloseableHttpClient createHttpClient(Map<String, Object> parameters) throws Exception {
        CompositeHttpConfigurer configurer = new CompositeHttpConfigurer();
        this.configureAuthentication(parameters).ifPresent(configurer::addConfigurer);
        this.configureProxy(parameters).ifPresent(configurer::addConfigurer);
        HttpClientBuilder builder = HttpClientBuilder.create();
        configurer.configureHttpClient(builder);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        this.setProperties(builder, "httpClient.", parameters);
        this.setProperties(requestConfigBuilder, "httpClient.", parameters);
        return builder.setDefaultRequestConfig(requestConfigBuilder.build()).build();
    }
}

