/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.http.HttpActivityListener;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GZIPHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.processor.DefaultMaskingFormatter;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;

@Metadata(label="bean", description="Logs HTTP requests and responses for the camel-http component.", annotations={"interfaceName=org.apache.camel.component.http.HttpActivityListener"})
@Configurer(metadataOnly=true)
public class LoggingHttpActivityListener
extends ServiceSupport
implements CamelContextAware,
HttpActivityListener {
    private CamelContext camelContext;
    private MaskingFormatter maskingFormatter;
    @Metadata(defaultValue="INFO", enums="TRACE,DEBUG,INFO,WARN,ERROR,OFF")
    private String loggingLevel;
    @Metadata(defaultValue="true", description="Show route ID")
    private boolean showRouteId = true;
    @Metadata(defaultValue="true", description="Show route Group")
    private boolean showRouteGroup = true;
    @Metadata(defaultValue="true", description="Show the unique exchange ID")
    private boolean showExchangeId = true;
    @Metadata(defaultValue="true", description="Show the HTTP body")
    private boolean showBody = true;
    @Metadata(defaultValue="true", label="formatting", description="Show the HTTP headers")
    private boolean showHeaders = true;
    @Metadata(defaultValue="true", description="Whether to show HTTP body that are streaming based. Beware that Camel will have to read the content into memory to print to log, and will re-create the HttpEntity stored on the request/response object. If you have large payloads then this can impact performance.")
    private boolean showStreams = true;
    @Metadata(defaultValue="false", description="Whether to show HTTP body that are binary based (uses content-type to determine whether binary)")
    private boolean showBinary;
    @Metadata(defaultValue="50000", description="Limits the number of characters logged from the HTTP body")
    private int maxChars = 50000;
    @Metadata(description="If true, mask sensitive information like password or passphrase in the log")
    private Boolean logMask;
    @Metadata(defaultValue="true", description="If enabled then each information is outputted as separate LOG events")
    private boolean multiline;
    @Metadata(defaultValue="true", description="If enabled then the source location of where the log endpoint is used in Camel routes, would be used as logger name, instead of the given name. However, if the source location is disabled or not possible to resolve then the existing logger name will be used.")
    private boolean sourceLocationLoggerName = true;

    protected void doInit() throws Exception {
        this.maskingFormatter = (MaskingFormatter)this.getCamelContext().getRegistry().lookupByNameAndType("CamelCustomLogMask", MaskingFormatter.class);
        if (this.maskingFormatter == null) {
            this.maskingFormatter = new DefaultMaskingFormatter();
        }
    }

    @Override
    public void onRequestSubmitted(Object source, Exchange exchange, HttpHost host, HttpRequest request, HttpEntity entity) {
        CamelLogger logger = this.getLogger(source, exchange);
        if (logger.shouldLog()) {
            this.onActivity(logger, exchange, host, request, null, entity, -1L);
        }
    }

    @Override
    public void onResponseReceived(Object source, Exchange exchange, HttpHost host, HttpResponse response, HttpEntity entity, long elapsed) {
        CamelLogger logger = this.getLogger(source, exchange);
        if (logger.shouldLog()) {
            this.onActivity(logger, exchange, host, null, response, entity, elapsed);
        }
    }

    protected void onActivity(CamelLogger logger, Exchange exchange, HttpHost host, HttpRequest request, HttpResponse response, HttpEntity entity, long elapsed) {
        StringJoiner top = new StringJoiner("");
        ArrayList<String> lines = new ArrayList<String>();
        String routeId = ExchangeHelper.getRouteId((Exchange)exchange);
        String routeGroup = ExchangeHelper.getRouteGroup((Exchange)exchange);
        String exchangeId = exchange.getExchangeId();
        String protocol = null;
        if (request != null) {
            String string = protocol = request.getVersion() != null ? request.getVersion().toString() : "HTTP/1.1";
        }
        if (request != null) {
            top.add("Sending HTTP Request   (");
        } else {
            top.add("Received HTTP Response (");
        }
        top.add(String.format("host: %s", host.toHostString()));
        if (this.showRouteGroup && this.showRouteId) {
            if (routeGroup != null && routeId != null) {
                top.add(String.format(" route: %s/%s", routeGroup, routeId));
            } else if (routeId != null) {
                top.add(String.format(" route: %s", routeId));
            }
        }
        if (this.showExchangeId) {
            top.add(String.format(" exchangeId: %s", exchangeId));
        }
        if (elapsed != -1L) {
            top.add(String.format(" elapsed: %sms", elapsed));
        }
        top.add(")");
        if (request != null) {
            lines.add(String.format("%s %s %s", request.getMethod(), request.getPath(), protocol));
        } else {
            lines.add(String.format("%s %s %s", response.getVersion().toString(), response.getCode(), response.getReasonPhrase()));
        }
        if (this.showHeaders) {
            Header[] headers;
            for (Header h : headers = request != null ? request.getHeaders() : response.getHeaders()) {
                lines.add(String.format("%s: %s", h.getName(), this.getValue(h.isSensitive(), h.getValue())));
            }
        }
        if (this.showBody) {
            lines.add("");
            try {
                HttpEntity e = entity;
                if (e != null) {
                    if (e.isStreaming() && !this.showStreams) {
                        lines.add("WARN: Cannot log HTTP body because the body is streaming");
                    } else {
                        boolean accepted;
                        ContentType ct = null;
                        if (e.getContentType() != null) {
                            ct = ContentType.parse((CharSequence)e.getContentType());
                        }
                        if (this.showBinary || ct == null) {
                            accepted = true;
                        } else {
                            boolean bl = accepted = !this.isBinaryData(ct);
                        }
                        if (!accepted) {
                            lines.add("WARN: Cannot log HTTP body because the body is binary");
                        } else {
                            Object data;
                            Header ce = request != null ? request.getHeader("Content-Encoding") : response.getHeader("Content-Encoding");
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            e.writeTo((OutputStream)bos);
                            if (ce != null && GZIPHelper.isGzip((String)ce.getValue())) {
                                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                                InputStream is = GZIPHelper.uncompressGzip((String)ce.getValue(), (InputStream)bis);
                                data = new String(is.readAllBytes());
                                IOHelper.close((Closeable)is);
                            } else {
                                data = bos.toString();
                            }
                            if (((String)data).length() > this.maxChars) {
                                data = ((String)data).substring(0, this.maxChars) + " ... [Body clipped after " + this.maxChars + " chars, total length is " + ((String)data).length() + "]";
                            }
                            lines.add(this.getValue(false, data));
                            if (!e.isRepeatable()) {
                                byte[] arr = bos.toByteArray();
                                e = new ByteArrayEntity(arr, ct);
                                if (request instanceof HttpEntityContainer) {
                                    HttpEntityContainer ec = (HttpEntityContainer)request;
                                    ec.setEntity(e);
                                } else if (response instanceof HttpEntityContainer) {
                                    HttpEntityContainer ec = (HttpEntityContainer)response;
                                    ec.setEntity(e);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.multiline) {
            logger.log(top.toString());
            lines.forEach(arg_0 -> ((CamelLogger)logger).log(arg_0));
        } else {
            StringJoiner sj = new StringJoiner(System.lineSeparator());
            sj.add(top.toString());
            lines.forEach(sj::add);
            logger.log(sj.toString());
        }
    }

    protected boolean isBinaryData(ContentType ct) {
        String t = ct.getMimeType();
        return !t.contains("text") && !t.contains("xml") && !t.contains("json") && !t.contains("multipart") && !t.contains("x-www-form-urlencoded");
    }

    private CamelLogger getLogger(Object source, Exchange exchange) {
        String name = null;
        if (this.sourceLocationLoggerName) {
            name = LoggerHelper.getLineNumberLoggerName((Object)source);
        }
        if (name == null) {
            name = LoggingHttpActivityListener.class.getName();
        }
        LoggingLevel level = LoggingLevel.INFO;
        if (this.loggingLevel != null && !this.loggingLevel.equals("INFO")) {
            level = LoggingLevel.valueOf((String)this.loggingLevel);
        }
        return new CamelLogger(name, level);
    }

    private String getValue(boolean sensitive, Object value) {
        String v;
        String string = v = value != null ? value.toString() : null;
        if (v != null && (sensitive || this.logMask != null && this.logMask.booleanValue())) {
            v = this.maskingFormatter.format(v);
        }
        return v;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public boolean isShowRouteId() {
        return this.showRouteId;
    }

    public void setShowRouteId(boolean showRouteId) {
        this.showRouteId = showRouteId;
    }

    public boolean isShowRouteGroup() {
        return this.showRouteGroup;
    }

    public void setShowRouteGroup(boolean showRouteGroup) {
        this.showRouteGroup = showRouteGroup;
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowStreams() {
        return this.showStreams;
    }

    public void setShowStreams(boolean showStreams) {
        this.showStreams = showStreams;
    }

    public boolean isShowBinary() {
        return this.showBinary;
    }

    public void setShowBinary(boolean showBinary) {
        this.showBinary = showBinary;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public Boolean getLogMask() {
        return this.logMask;
    }

    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isSourceLocationLoggerName() {
        return this.sourceLocationLoggerName;
    }

    public void setSourceLocationLoggerName(boolean sourceLocationLoggerName) {
        this.sourceLocationLoggerName = sourceLocationLoggerName;
    }
}

