/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.helper;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class HttpMethodHelper {
    private HttpMethodHelper() {
    }

    public static HttpMethods createMethod(Exchange exchange, HttpEndpoint endpoint) throws URISyntaxException {
        HttpMethods answer;
        String queryString = null;
        String uriString = null;
        if (!endpoint.isSkipControlHeaders()) {
            queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
            uriString = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        }
        if (uriString != null) {
            try {
                uriString = exchange.getContext().resolvePropertyPlaceholders(uriString);
            }
            catch (Exception e) {
                throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uriString, exchange, (Throwable)e);
            }
            uriString = UnsafeUriCharactersEncoder.encodeHttpURI((String)uriString);
            URI uri = new URI(uriString);
            queryString = uri.getQuery();
        }
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getRawQuery();
        }
        if (endpoint.getHttpMethod() != null) {
            answer = HttpMethods.valueOf(endpoint.getHttpMethod().name());
        } else {
            HttpMethods m = null;
            if (!endpoint.isSkipControlHeaders()) {
                m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class));
            }
            answer = m != null ? m : (queryString != null ? HttpMethods.GET : (exchange.getMessage().getBody() != null ? HttpMethods.POST : HttpMethods.GET));
        }
        return answer;
    }
}

