/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.Service;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.http.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.CompositeHttpConfigurer;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponentVerifierExtension;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.OAuth2ClientConfigurer;
import org.apache.camel.component.http.ProxyHttpClientConfigurer;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpRestHeaderFilterStrategy;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.RestProducerFactoryHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="http,https")
public class HttpComponent
extends HttpCommonComponent
implements RestProducerFactory,
SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(HttpComponent.class);
    @Metadata(label="advanced", description="To use the custom HttpClientConfigurer to perform configuration of the HttpClient that will be used.")
    protected HttpClientConfigurer httpClientConfigurer;
    @Metadata(label="advanced", description="To use a custom and shared HttpClientConnectionManager to manage connections. If this has been configured then this is always used for all endpoints created by this component.")
    protected HttpClientConnectionManager clientConnectionManager;
    @Metadata(label="advanced", description="To use a custom org.apache.hc.core5.http.protocol.HttpContext when executing requests.")
    protected HttpContext httpContext;
    @Metadata(label="security", description="To configure security using SSLContextParameters. Important: Only one instance of org.apache.camel.support.jsse.SSLContextParameters is supported per HttpComponent. If you need to use 2 or more different instances, you need to define a new HttpComponent per instance you need.")
    protected SSLContextParameters sslContextParameters;
    @Metadata(label="security", description="To use a custom X509HostnameVerifier such as DefaultHostnameVerifier or NoopHostnameVerifier.")
    protected HostnameVerifier x509HostnameVerifier = new DefaultHostnameVerifier();
    @Metadata(label="producer,advanced", description="To use a custom org.apache.hc.client5.http.cookie.CookieStore. By default the org.apache.hc.client5.http.cookie.BasicCookieStore is used which is an in-memory only cookie store. Notice if bridgeEndpoint=true then the cookie store is forced to be a noop cookie store as cookie shouldn't be stored as we are just bridging (eg acting as a proxy).")
    protected CookieStore cookieStore;
    @Metadata(label="timeout", defaultValue="3 minutes", description="Returns the connection lease request timeout used when requesting a connection from the connection manager. A timeout value of zero is interpreted as a disabled timeout.", javaType="org.apache.hc.core5.util.Timeout")
    protected Timeout connectionRequestTimeout = Timeout.ofMinutes((long)3L);
    @Metadata(label="timeout", defaultValue="3 minutes", description="Determines the timeout until a new connection is fully established. A timeout value of zero is interpreted as an infinite timeout.", javaType="org.apache.hc.core5.util.Timeout")
    protected Timeout connectTimeout = Timeout.ofMinutes((long)3L);
    @Metadata(label="timeout", defaultValue="3 minutes", description="Determines the default socket timeout value for blocking I/O operations.", javaType="org.apache.hc.core5.util.Timeout")
    protected Timeout soTimeout = Timeout.ofMinutes((long)3L);
    @Metadata(label="timeout", defaultValue="0", description="Determines the timeout until arrival of a response from the opposite endpoint. A timeout value of zero is interpreted as an infinite timeout. Please note that response timeout may be unsupported by HTTP transports with message multiplexing.", javaType="org.apache.hc.core5.util.Timeout")
    protected Timeout responseTimeout = Timeout.ofMilliseconds((long)0L);
    @Metadata(label="producer,proxy", enums="http,https", description="Proxy authentication protocol scheme")
    protected String proxyAuthScheme;
    @Metadata(label="producer,proxy", enums="Basic,Digest,NTLM", description="Proxy authentication method to use")
    protected String proxyAuthMethod;
    @Metadata(label="producer,proxy", secret=true, description="Proxy authentication username")
    protected String proxyAuthUsername;
    @Metadata(label="producer,proxy", secret=true, description="Proxy authentication password")
    protected String proxyAuthPassword;
    @Metadata(label="producer,proxy", description="Proxy authentication host")
    protected String proxyAuthHost;
    @Metadata(label="producer,proxy", description="Proxy authentication port")
    protected Integer proxyAuthPort;
    @Metadata(label="producer,proxy", description="Proxy authentication domain to use")
    protected String proxyAuthDomain;
    @Metadata(label="producer,proxy", description="Proxy authentication domain (workstation name) to use with NTML")
    protected String proxyAuthNtHost;
    @Metadata(label="advanced", defaultValue="200", description="The maximum number of connections.")
    protected int maxTotalConnections = 200;
    @Metadata(label="advanced", defaultValue="20", description="The maximum number of connections per route.")
    protected int connectionsPerRoute = 20;
    @Metadata(label="advanced", description="The time for connection to live, the time unit is millisecond, the default value is always keep alive.")
    protected long connectionTimeToLive = -1L;
    @Metadata(label="security", defaultValue="false", description="Enable usage of global SSL context parameters.")
    protected boolean useGlobalSslContextParameters;
    @Metadata(label="producer,advanced", defaultValue="8192", description="This threshold in bytes controls whether the response payload should be stored in memory as a byte array or be streaming based. Set this to -1 to always use streaming mode.")
    protected int responsePayloadStreamingThreshold = 8192;
    @Metadata(label="advanced", description="Disables automatic redirect handling")
    protected boolean redirectHandlingDisabled;
    @Metadata(label="advanced", description="Disables automatic request recovery and re-execution")
    protected boolean automaticRetriesDisabled;
    @Metadata(label="advanced", description="Disables automatic content decompression")
    protected boolean contentCompressionDisabled;
    @Metadata(label="advanced", description="Disables state (cookie) management")
    protected boolean cookieManagementDisabled;
    @Metadata(label="advanced", description="Disables authentication scheme caching")
    protected boolean authCachingDisabled;
    @Metadata(label="advanced", description="Disables connection state tracking")
    protected boolean connectionStateDisabled;
    @Metadata(label="advanced", description="Disables the default user agent set by this builder if none has been provided by the user")
    protected boolean defaultUserAgentDisabled;
    @Metadata(label="producer,advanced", defaultValue="true", description="If this option is true then IN exchange headers will be copied to OUT exchange headers according to copy strategy. Setting this to false, allows to only include the headers from the HTTP response (not propagating IN headers).")
    protected boolean copyHeaders = true;
    @Metadata(label="producer,advanced", description="Whether to skip mapping all the Camel headers as HTTP request headers. If there are no data from Camel headers needed to be included in the HTTP request then this can avoid parsing overhead with many object allocations for the JVM garbage collector.")
    protected boolean skipRequestHeaders;
    @Metadata(label="producer,advanced", description="Whether to skip mapping all the HTTP response headers to Camel headers. If there are no data needed from HTTP headers then this can avoid parsing overhead with many object allocations for the JVM garbage collector.")
    protected boolean skipResponseHeaders;
    @Metadata(label="producer", defaultValue="false", description="Whether to the HTTP request should follow redirects. By default the HTTP request does not follow redirects ")
    protected boolean followRedirects;
    @UriParam(label="producer,advanced", description="To set a custom HTTP User-Agent request header")
    protected String userAgent;

    public HttpComponent() {
        this.registerExtension(HttpComponentVerifierExtension::new);
    }

    protected HttpClientConfigurer createHttpClientConfigurer(Map<String, Object> parameters, boolean secure) throws Exception {
        HttpClientConfigurer configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class);
        if (configurer == null) {
            configurer = this.getHttpClientConfigurer();
        }
        HttpCredentialsHelper credentialsProvider = new HttpCredentialsHelper();
        configurer = this.configureBasicAuthentication(parameters, configurer, credentialsProvider);
        configurer = this.configureHttpProxy(parameters, configurer, secure, credentialsProvider);
        configurer = this.configureOAuth2Authentication(parameters, configurer);
        return configurer;
    }

    private HttpClientConfigurer configureOAuth2Authentication(Map<String, Object> parameters, HttpClientConfigurer configurer) {
        String clientId = (String)this.getParameter(parameters, "oauth2ClientId", String.class);
        String clientSecret = (String)this.getParameter(parameters, "oauth2ClientSecret", String.class);
        String tokenEndpoint = (String)this.getParameter(parameters, "oauth2TokenEndpoint", String.class);
        if (clientId != null && clientSecret != null && tokenEndpoint != null) {
            return CompositeHttpConfigurer.combineConfigurers(configurer, new OAuth2ClientConfigurer(clientId, clientSecret, tokenEndpoint));
        }
        return configurer;
    }

    private HttpClientConfigurer configureBasicAuthentication(Map<String, Object> parameters, HttpClientConfigurer configurer, HttpCredentialsHelper credentialsProvider) {
        String authUsername = (String)this.getParameter(parameters, "authUsername", String.class);
        String authPassword = (String)this.getParameter(parameters, "authPassword", String.class);
        if (authUsername != null && authPassword != null) {
            String authDomain = (String)this.getParameter(parameters, "authDomain", String.class);
            String authHost = (String)this.getParameter(parameters, "authHost", String.class);
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(authUsername, authPassword, authDomain, authHost, credentialsProvider));
        }
        if (this.httpConfiguration != null && "basic".equalsIgnoreCase(this.httpConfiguration.getAuthMethod())) {
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(this.httpConfiguration.getAuthUsername(), this.httpConfiguration.getAuthPassword(), this.httpConfiguration.getAuthDomain(), this.httpConfiguration.getAuthHost(), credentialsProvider));
        }
        return configurer;
    }

    private HttpClientConfigurer configureHttpProxy(Map<String, Object> parameters, HttpClientConfigurer configurer, boolean secure, HttpCredentialsHelper credentialsProvider) {
        String proxyAuthScheme = (String)this.getParameter(parameters, "proxyAuthScheme", String.class, this.getProxyAuthScheme());
        if (proxyAuthScheme == null) {
            proxyAuthScheme = secure ? "https" : "http";
        }
        String proxyAuthHost = (String)this.getParameter(parameters, "proxyAuthHost", String.class, this.getProxyAuthHost());
        Integer proxyAuthPort = (Integer)this.getParameter(parameters, "proxyAuthPort", Integer.class, this.getProxyAuthPort());
        if (proxyAuthHost == null) {
            proxyAuthHost = (String)this.getParameter(parameters, "proxyHost", String.class);
        }
        if (proxyAuthPort == null) {
            proxyAuthPort = (Integer)this.getParameter(parameters, "proxyPort", Integer.class);
        }
        if (proxyAuthHost != null && proxyAuthPort != null) {
            String proxyAuthUsername = (String)this.getParameter(parameters, "proxyAuthUsername", String.class, this.getProxyAuthUsername());
            String proxyAuthPassword = (String)this.getParameter(parameters, "proxyAuthPassword", String.class, this.getProxyAuthPassword());
            String proxyAuthDomain = (String)this.getParameter(parameters, "proxyAuthDomain", String.class, this.getProxyAuthDomain());
            String proxyAuthNtHost = (String)this.getParameter(parameters, "proxyAuthNtHost", String.class, this.getProxyAuthNtHost());
            LOG.debug("Configuring HTTP client to use HTTP proxy {}:{}", (Object)proxyAuthHost, (Object)proxyAuthPort);
            if (proxyAuthUsername != null && proxyAuthPassword != null) {
                return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme, proxyAuthUsername, proxyAuthPassword, proxyAuthDomain, proxyAuthNtHost, credentialsProvider));
            }
            return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme));
        }
        return configurer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String part;
        boolean secure;
        HashMap<String, Object> httpClientParameters = new HashMap<String, Object>(parameters);
        HashMap<String, Object> httpClientOptions = new HashMap<String, Object>();
        Timeout valConnectionRequestTimeout = (Timeout)this.getAndRemoveParameter(parameters, "connectionRequestTimeout", Timeout.class, this.connectionRequestTimeout);
        if (!Timeout.ofMinutes((long)3L).equals((Object)valConnectionRequestTimeout)) {
            httpClientOptions.put("connectionRequestTimeout", valConnectionRequestTimeout);
        }
        Timeout valResponseTimeout = (Timeout)this.getAndRemoveParameter(parameters, "responseTimeout", Timeout.class, this.responseTimeout);
        if (!Timeout.ofMilliseconds((long)0L).equals((Object)valResponseTimeout)) {
            httpClientOptions.put("responseTimeout", valResponseTimeout);
        }
        Timeout valConnectTimeout = (Timeout)this.getAndRemoveParameter(parameters, "connectTimeout", Timeout.class, this.connectTimeout);
        if (!Timeout.ofMinutes((long)3L).equals((Object)valConnectTimeout)) {
            httpClientOptions.put("connectTimeout", valConnectTimeout);
        }
        HashMap<String, Object> httpConnectionOptions = new HashMap<String, Object>();
        Timeout valSoTimeout = (Timeout)this.getAndRemoveParameter(parameters, "soTimeout", Timeout.class, this.soTimeout);
        if (!Timeout.ofMinutes((long)3L).equals((Object)valSoTimeout)) {
            httpConnectionOptions.put("soTimeout", valSoTimeout);
        }
        HttpBinding httpBinding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        HttpContext httpContext = (HttpContext)this.resolveAndRemoveReferenceParameter(parameters, "httpContext", HttpContext.class);
        SSLContextParameters sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParameters", SSLContextParameters.class);
        if (sslContextParameters == null) {
            sslContextParameters = this.getSslContextParameters();
        }
        if (sslContextParameters == null && (secure = HttpHelper.isSecureConnection((String)uri))) {
            sslContextParameters = this.retrieveGlobalSslContextParameters();
        }
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        boolean muteException = (Boolean)this.getAndRemoveParameter(parameters, "muteException", Boolean.TYPE, this.isMuteException());
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        boolean secure2 = HttpHelper.isSecureConnection((String)uri) || sslContextParameters != null;
        Object addressUri = (secure2 ? "https://" : "http://") + remaining;
        addressUri = UnsafeUriCharactersEncoder.encodeHttpURI((String)addressUri);
        URI uriHttpUriAddress = new URI((String)addressUri);
        int pos = uri.indexOf("//");
        if (pos != -1 && ((part = uri.substring(pos + 2)).startsWith("http:") || part.startsWith("https:"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, secure2);
        URI endpointUri = URISupport.createRemainingURI((URI)uriHttpUriAddress, httpClientParameters);
        String scheme = StringHelper.before((String)uri, (String)"://");
        endpointUri = URISupport.createRemainingURI((URI)new URI(scheme, endpointUri.getUserInfo(), endpointUri.getHost(), endpointUri.getPort(), endpointUri.getPath(), endpointUri.getQuery(), endpointUri.getFragment()), httpClientParameters);
        String endpointUriString = endpointUri.toString();
        LOG.debug("Creating endpoint uri {}", (Object)endpointUriString);
        HttpClientConnectionManager localConnectionManager = this.createConnectionManager(parameters, sslContextParameters, httpConnectionOptions);
        HttpClientBuilder clientBuilder = this.createHttpClientBuilder(uri, parameters, httpClientOptions);
        HttpEndpoint endpoint = new HttpEndpoint(endpointUriString, this, clientBuilder, localConnectionManager, configurer);
        endpoint.setResponseTimeout(valResponseTimeout);
        endpoint.setSoTimeout(valSoTimeout);
        endpoint.setConnectTimeout(valConnectTimeout);
        endpoint.setConnectionRequestTimeout(valConnectionRequestTimeout);
        endpoint.setCopyHeaders(this.copyHeaders);
        endpoint.setSkipRequestHeaders(this.skipRequestHeaders);
        endpoint.setSkipResponseHeaders(this.skipResponseHeaders);
        endpoint.setUserAgent(this.userAgent);
        endpoint.setMuteException(muteException);
        if (this.getHttpConfiguration() != null) {
            HashMap properties = new HashMap();
            BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection((CamelContext)this.getCamelContext());
            beanIntrospection.getProperties((Object)this.getHttpConfiguration(), properties, null);
            this.setProperties((Endpoint)endpoint, properties);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uriHttpUriAddress.getScheme(), uriHttpUriAddress.getUserInfo(), uriHttpUriAddress.getHost(), uriHttpUriAddress.getPort(), uriHttpUriAddress.getPath(), uriHttpUriAddress.getQuery(), uriHttpUriAddress.getFragment()), parameters);
        endpoint.setHttpUri(httpUri);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        endpoint.setHttpBinding(this.getHttpBinding());
        if (httpBinding != null) {
            endpoint.setHttpBinding(httpBinding);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        endpoint.setHttpContext(this.getHttpContext());
        if (httpContext != null) {
            endpoint.setHttpContext(httpContext);
        }
        if (endpoint.getCookieStore() == null) {
            endpoint.setCookieStore(this.getCookieStore());
        }
        endpoint.setHttpClientOptions(httpClientOptions);
        endpoint.setHttpConnectionOptions(httpConnectionOptions);
        return endpoint;
    }

    protected HttpClientConnectionManager createConnectionManager(Map<String, Object> parameters, SSLContextParameters sslContextParameters, Map<String, Object> httpConnectionOptions) throws GeneralSecurityException, IOException {
        if (this.clientConnectionManager != null) {
            return this.clientConnectionManager;
        }
        HostnameVerifier resolvedHostnameVerifier = (HostnameVerifier)this.resolveAndRemoveReferenceParameter(parameters, "x509HostnameVerifier", HostnameVerifier.class);
        HostnameVerifier hostnameVerifier = Optional.ofNullable(resolvedHostnameVerifier).orElse(this.x509HostnameVerifier);
        int maxTotalConnections = (Integer)this.getAndRemoveParameter(parameters, "maxTotalConnections", Integer.TYPE, 0);
        int connectionsPerRoute = (Integer)this.getAndRemoveParameter(parameters, "connectionsPerRoute", Integer.TYPE, 0);
        boolean useSystemProperties = (Boolean)CamelContextHelper.mandatoryConvertTo((CamelContext)this.getCamelContext(), Boolean.TYPE, (Object)parameters.get("useSystemProperties"));
        Registry<ConnectionSocketFactory> connectionRegistry = this.createConnectionRegistry(hostnameVerifier, sslContextParameters, useSystemProperties);
        httpConnectionOptions.putAll(PropertiesHelper.extractProperties(parameters, (String)"httpConnection."));
        SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)socketConfigBuilder, httpConnectionOptions);
        return this.createConnectionManager(connectionRegistry, maxTotalConnections, connectionsPerRoute, socketConfigBuilder.build());
    }

    protected HttpClientBuilder createHttpClientBuilder(String uri, Map<String, Object> parameters, Map<String, Object> httpClientOptions) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        httpClientOptions.putAll(PropertiesHelper.extractProperties(parameters, (String)"httpClient."));
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)clientBuilder, httpClientOptions);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)requestConfigBuilder, httpClientOptions);
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        this.validateParameters(uri, httpClientOptions, null);
        boolean fr = (Boolean)this.getParameter(parameters, "followRedirects", Boolean.class, this.followRedirects);
        if (this.redirectHandlingDisabled || !fr) {
            clientBuilder.disableRedirectHandling();
        }
        if (this.automaticRetriesDisabled) {
            clientBuilder.disableAutomaticRetries();
        }
        if (this.contentCompressionDisabled) {
            clientBuilder.disableContentCompression();
        }
        if (this.cookieManagementDisabled) {
            clientBuilder.disableCookieManagement();
        }
        if (this.authCachingDisabled) {
            clientBuilder.disableAuthCaching();
        }
        if (this.connectionStateDisabled) {
            clientBuilder.disableConnectionState();
        }
        if (this.defaultUserAgentDisabled) {
            clientBuilder.disableDefaultUserAgent();
        }
        if (fr) {
            clientBuilder.setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE);
        }
        return clientBuilder;
    }

    protected Registry<ConnectionSocketFactory> createConnectionRegistry(HostnameVerifier x509HostnameVerifier, SSLContextParameters sslContextParams, boolean useSystemProperties) throws GeneralSecurityException, IOException {
        RegistryBuilder builder = RegistryBuilder.create();
        builder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (sslContextParams != null) {
            builder.register("https", (Object)new SSLConnectionSocketFactory(sslContextParams.createSSLContext(this.getCamelContext()), x509HostnameVerifier));
        } else {
            builder.register("https", (Object)new SSLConnectionSocketFactory(useSystemProperties ? SSLContexts.createSystemDefault() : SSLContexts.createDefault(), x509HostnameVerifier));
        }
        return builder.build();
    }

    protected HttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> registry, int maxTotalConnections, int connectionsPerRoute, SocketConfig defaultSocketConfig) {
        PoolingHttpClientConnectionManager answer = new PoolingHttpClientConnectionManager(registry, PoolConcurrencyPolicy.STRICT, TimeValue.ofMilliseconds((long)this.getConnectionTimeToLive()), null);
        int localMaxTotalConnections = maxTotalConnections;
        if (localMaxTotalConnections == 0) {
            localMaxTotalConnections = this.getMaxTotalConnections();
        }
        if (localMaxTotalConnections > 0) {
            answer.setMaxTotal(localMaxTotalConnections);
        }
        answer.setDefaultSocketConfig(defaultSocketConfig);
        int localConnectionsPerRoute = connectionsPerRoute;
        if (localConnectionsPerRoute == 0) {
            localConnectionsPerRoute = this.getConnectionsPerRoute();
        }
        if (localConnectionsPerRoute > 0) {
            answer.setDefaultMaxPerRoute(localConnectionsPerRoute);
        }
        LOG.debug("Created ClientConnectionManager {}", (Object)answer);
        return answer;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String query;
        RestConfiguration config;
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        Object url = host;
        if (!ObjectHelper.isEmpty((String)basePath)) {
            url = (String)url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((String)uriTemplate)) {
            url = (String)url + "/" + uriTemplate;
        }
        if ((config = configuration) == null) {
            config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), null, (String)"http");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (config.getProducerComponent() == null || config.getProducerComponent().equals("http")) {
            map.put("httpMethod", verb);
            if (config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
                map.putAll(config.getEndpointProperties());
            }
        }
        if (!(query = URISupport.createQueryString(map)).isEmpty()) {
            url = (String)url + "?" + query;
        }
        parameters = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap();
        RestProducerFactoryHelper.setupComponentFor((String)url, (CamelContext)camelContext, (Map)((Map)parameters.remove("component")));
        HttpEndpoint endpoint = (HttpEndpoint)camelContext.getEndpoint((String)url, parameters);
        String path = uriTemplate != null ? uriTemplate : basePath;
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            endpoint.setHeaderFilterStrategy((HeaderFilterStrategy)new HttpRestHeaderFilterStrategy(path, queryParameters));
        }
        ServiceHelper.startService((Service)endpoint);
        return endpoint.createProducer();
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public HostnameVerifier getX509HostnameVerifier() {
        return this.x509HostnameVerifier;
    }

    public void setX509HostnameVerifier(HostnameVerifier x509HostnameVerifier) {
        this.x509HostnameVerifier = x509HostnameVerifier;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getConnectionsPerRoute() {
        return this.connectionsPerRoute;
    }

    public void setConnectionsPerRoute(int connectionsPerRoute) {
        this.connectionsPerRoute = connectionsPerRoute;
    }

    public long getConnectionTimeToLive() {
        return this.connectionTimeToLive;
    }

    public void setConnectionTimeToLive(long connectionTimeToLive) {
        this.connectionTimeToLive = connectionTimeToLive;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public Timeout getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(Timeout connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public Timeout getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Timeout connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Timeout getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Timeout soTimeout) {
        this.soTimeout = soTimeout;
    }

    public Timeout getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Timeout responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public String getProxyAuthScheme() {
        return this.proxyAuthScheme;
    }

    public void setProxyAuthScheme(String proxyAuthScheme) {
        this.proxyAuthScheme = proxyAuthScheme;
    }

    public String getProxyAuthMethod() {
        return this.proxyAuthMethod;
    }

    public void setProxyAuthMethod(String proxyAuthMethod) {
        this.proxyAuthMethod = proxyAuthMethod;
    }

    public String getProxyAuthUsername() {
        return this.proxyAuthUsername;
    }

    public void setProxyAuthUsername(String proxyAuthUsername) {
        this.proxyAuthUsername = proxyAuthUsername;
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = proxyAuthPassword;
    }

    public String getProxyAuthHost() {
        return this.proxyAuthHost;
    }

    public void setProxyAuthHost(String proxyAuthHost) {
        this.proxyAuthHost = proxyAuthHost;
    }

    public Integer getProxyAuthPort() {
        return this.proxyAuthPort;
    }

    public void setProxyAuthPort(Integer proxyAuthPort) {
        this.proxyAuthPort = proxyAuthPort;
    }

    public String getProxyAuthDomain() {
        return this.proxyAuthDomain;
    }

    public void setProxyAuthDomain(String proxyAuthDomain) {
        this.proxyAuthDomain = proxyAuthDomain;
    }

    public String getProxyAuthNtHost() {
        return this.proxyAuthNtHost;
    }

    public void setProxyAuthNtHost(String proxyAuthNtHost) {
        this.proxyAuthNtHost = proxyAuthNtHost;
    }

    public int getResponsePayloadStreamingThreshold() {
        return this.responsePayloadStreamingThreshold;
    }

    public void setResponsePayloadStreamingThreshold(int responsePayloadStreamingThreshold) {
        this.responsePayloadStreamingThreshold = responsePayloadStreamingThreshold;
    }

    public boolean isRedirectHandlingDisabled() {
        return this.redirectHandlingDisabled;
    }

    public void setRedirectHandlingDisabled(boolean redirectHandlingDisabled) {
        this.redirectHandlingDisabled = redirectHandlingDisabled;
    }

    public boolean isAutomaticRetriesDisabled() {
        return this.automaticRetriesDisabled;
    }

    public void setAutomaticRetriesDisabled(boolean automaticRetriesDisabled) {
        this.automaticRetriesDisabled = automaticRetriesDisabled;
    }

    public boolean isContentCompressionDisabled() {
        return this.contentCompressionDisabled;
    }

    public void setContentCompressionDisabled(boolean contentCompressionDisabled) {
        this.contentCompressionDisabled = contentCompressionDisabled;
    }

    public boolean isCookieManagementDisabled() {
        return this.cookieManagementDisabled;
    }

    public void setCookieManagementDisabled(boolean cookieManagementDisabled) {
        this.cookieManagementDisabled = cookieManagementDisabled;
    }

    public boolean isAuthCachingDisabled() {
        return this.authCachingDisabled;
    }

    public void setAuthCachingDisabled(boolean authCachingDisabled) {
        this.authCachingDisabled = authCachingDisabled;
    }

    public boolean isConnectionStateDisabled() {
        return this.connectionStateDisabled;
    }

    public void setConnectionStateDisabled(boolean connectionStateDisabled) {
        this.connectionStateDisabled = connectionStateDisabled;
    }

    public boolean isDefaultUserAgentDisabled() {
        return this.defaultUserAgentDisabled;
    }

    public void setDefaultUserAgentDisabled(boolean defaultUserAgentDisabled) {
        this.defaultUserAgentDisabled = defaultUserAgentDisabled;
    }

    public boolean isCopyHeaders() {
        return this.copyHeaders;
    }

    public void setCopyHeaders(boolean copyHeaders) {
        this.copyHeaders = copyHeaders;
    }

    public boolean isSkipRequestHeaders() {
        return this.skipRequestHeaders;
    }

    public void setSkipRequestHeaders(boolean skipRequestHeaders) {
        this.skipRequestHeaders = skipRequestHeaders;
    }

    public boolean isSkipResponseHeaders() {
        return this.skipResponseHeaders;
    }

    public void setSkipResponseHeaders(boolean skipResponseHeaders) {
        this.skipResponseHeaders = skipResponseHeaders;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        if (this.clientConnectionManager != null) {
            LOG.info("Shutting down ClientConnectionManager: {}", (Object)this.clientConnectionManager);
            this.clientConnectionManager.close();
            this.clientConnectionManager = null;
        }
        super.doStop();
    }

    public ComponentVerifierExtension getVerifier() {
        return (scope, parameters) -> ((ComponentVerifierExtension)this.getExtension(ComponentVerifierExtension.class).orElseThrow(UnsupportedOperationException::new)).verify(scope, parameters);
    }
}

