/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4.helper;

import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.HttpMethods;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;

public final class HttpProducerHelper {
    private HttpProducerHelper() {
    }

    public static String createURL(Exchange exchange, HttpEndpoint endpoint) {
        String path;
        String uri = null;
        if (!endpoint.isBridgeEndpoint()) {
            uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        }
        if (uri == null) {
            uri = endpoint.getHttpUri().toASCIIString();
        }
        if ((path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class)) != null) {
            block11: {
                if (path.startsWith("/")) {
                    String baseURIString = (String)exchange.getIn().getHeader("CamelHttpBaseUri", String.class);
                    try {
                        URI baseURI;
                        String basePath;
                        if (baseURIString == null) {
                            baseURIString = exchange.getFromEndpoint() != null ? exchange.getFromEndpoint().getEndpointUri() : "/";
                        }
                        if (path.startsWith(basePath = (baseURI = new URI(baseURIString)).getRawPath())) {
                            if ((path = path.substring(basePath.length())).startsWith("/")) {
                                path = path.substring(1);
                            }
                            break block11;
                        }
                        throw new RuntimeCamelException("Cannot analyze the Exchange.HTTP_PATH header, due to: cannot find the right HTTP_BASE_URI");
                    }
                    catch (Throwable t) {
                        throw new RuntimeCamelException("Cannot analyze the Exchange.HTTP_PATH header, due to: " + t.getMessage(), t);
                    }
                }
            }
            if (path.length() > 0) {
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                }
                uri = uri.concat(path);
            }
        }
        return uri;
    }

    public static HttpMethods createMethod(Exchange exchange, HttpEndpoint endpoint, boolean hasPayload) {
        HttpMethods m;
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getRawQuery();
        }
        HttpMethods answer = (m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class))) != null ? m : (queryString != null ? HttpMethods.GET : (hasPayload ? HttpMethods.POST : HttpMethods.GET));
        return answer;
    }

    public static HttpVersion parserHttpVersion(String s) throws ProtocolException {
        int minor;
        int major;
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        if (!s.startsWith("HTTP/")) {
            throw new ProtocolException("Invalid HTTP version string: " + s);
        }
        int i1 = "HTTP/".length();
        int i2 = s.indexOf(".", i1);
        if (i2 == -1) {
            throw new ProtocolException("Invalid HTTP version number: " + s);
        }
        try {
            major = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP major version number: " + s);
        }
        i1 = i2 + 1;
        i2 = s.length();
        try {
            minor = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP minor version number: " + s);
        }
        return new HttpVersion(major, minor);
    }
}

