/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4.helper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http4.HttpConverter;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.HttpMethods;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.util.IOHelper;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;

public final class HttpHelper {
    private HttpHelper() {
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        int index;
        if (contentType != null && (index = contentType.indexOf("charset=")) > 0) {
            String charset = contentType.substring(index + 8);
            exchange.setProperty("CamelCharsetName", (Object)IOConverter.normalizeCharset((String)charset));
        }
    }

    public static void writeObjectToServletResponse(ServletResponse response, Object target) throws IOException {
        response.setContentType("application/x-java-serialized-object");
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)response.getOutputStream());
        HttpHelper.writeObjectToStream((OutputStream)response.getOutputStream(), target);
    }

    public static void writeObjectToStream(OutputStream stream, Object target) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(target);
        oos.flush();
        IOHelper.close((Closeable)oos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        if (is == null) {
            return null;
        }
        Object answer = null;
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static Object readResponseBodyFromServletRequest(HttpServletRequest request, Exchange exchange) throws IOException {
        InputStream is = HttpConverter.toInputStream(request, exchange);
        return HttpHelper.readResponseBodyFromInputStream(is, exchange);
    }

    public static Object readResponseBodyFromInputStream(InputStream is, Exchange exchange) throws IOException {
        if (is == null) {
            return null;
        }
        if (((Boolean)exchange.getProperty("CamelDisableHttpStreamCache", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return is;
        }
        CachedOutputStream cos = new CachedOutputStream(exchange);
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)cos);
        return cos.getStreamCache();
    }

    public static String createURL(Exchange exchange, HttpEndpoint endpoint) {
        String path;
        String uri = null;
        if (!endpoint.isBridgeEndpoint()) {
            uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        }
        if (uri == null) {
            uri = endpoint.getHttpUri().toASCIIString();
        }
        if ((path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class)) != null) {
            block11: {
                if (path.startsWith("/")) {
                    String baseURIString = (String)exchange.getIn().getHeader("CamelHttpBaseUri", String.class);
                    try {
                        URI baseURI;
                        String basePath;
                        if (baseURIString == null) {
                            baseURIString = exchange.getFromEndpoint() != null ? exchange.getFromEndpoint().getEndpointUri() : "/";
                        }
                        if (path.startsWith(basePath = (baseURI = new URI(baseURIString)).getRawPath())) {
                            if ((path = path.substring(basePath.length())).startsWith("/")) {
                                path = path.substring(1);
                            }
                            break block11;
                        }
                        throw new RuntimeCamelException("Cannot analyze the Exchange.HTTP_PATH header, due to: cannot find the right HTTP_BASE_URI");
                    }
                    catch (Throwable t) {
                        throw new RuntimeCamelException("Cannot analyze the Exchange.HTTP_PATH header, due to: " + t.getMessage(), t);
                    }
                }
            }
            if (path.length() > 0) {
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                }
                uri = uri.concat(path);
            }
        }
        return uri;
    }

    public static HttpMethods createMethod(Exchange exchange, HttpEndpoint endpoint, boolean hasPayload) {
        HttpMethods m;
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getRawQuery();
        }
        HttpMethods answer = (m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class))) != null ? m : (queryString != null ? HttpMethods.GET : (hasPayload ? HttpMethods.POST : HttpMethods.GET));
        return answer;
    }

    public static HttpVersion parserHttpVersion(String s) throws ProtocolException {
        int minor;
        int major;
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        if (!s.startsWith("HTTP/")) {
            throw new ProtocolException("Invalid HTTP version string: " + s);
        }
        int i1 = "HTTP/".length();
        int i2 = s.indexOf(".", i1);
        if (i2 == -1) {
            throw new ProtocolException("Invalid HTTP version number: " + s);
        }
        try {
            major = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP major version number: " + s);
        }
        i1 = i2 + 1;
        i2 = s.length();
        try {
            minor = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP minor version number: " + s);
        }
        return new HttpVersion(major, minor);
    }
}

