/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.http4.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http4.CompositeHttpConfigurer;
import org.apache.camel.component.http4.HttpBinding;
import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.camel.component.http4.HttpConsumer;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.ProxyHttpClientConfigurer;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.http.auth.params.AuthParamBean;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnConnectionParamBean;
import org.apache.http.conn.params.ConnRouteParamBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.params.CookieSpecParamBean;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParamBean;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParamBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpComponent
extends HeaderFilterStrategyComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpComponent.class);
    protected HttpClientConfigurer httpClientConfigurer;
    protected ClientConnectionManager clientConnectionManager;
    protected HttpBinding httpBinding;
    protected X509HostnameVerifier x509HostnameVerifier = new BrowserCompatHostnameVerifier();
    protected int maxTotalConnections = 200;
    protected int connectionsPerRoute = 20;

    public void connect(HttpConsumer consumer) throws Exception {
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
    }

    protected HttpClientConfigurer createHttpClientConfigurer(Map<String, Object> parameters) {
        HttpClientConfigurer configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurerRef", HttpClientConfigurer.class);
        if (configurer == null && (configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class)) == null) {
            configurer = this.getHttpClientConfigurer();
        }
        configurer = this.configureBasicAuthentication(parameters, configurer);
        configurer = this.configureHttpProxy(parameters, configurer);
        return configurer;
    }

    private HttpClientConfigurer configureBasicAuthentication(Map<String, Object> parameters, HttpClientConfigurer configurer) {
        String username = (String)this.getAndRemoveParameter(parameters, "username", String.class);
        String password = (String)this.getAndRemoveParameter(parameters, "password", String.class);
        if (username != null && password != null) {
            String domain = (String)this.getAndRemoveParameter(parameters, "domain", String.class);
            String host = (String)this.getAndRemoveParameter(parameters, "host", String.class);
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(username, password, domain, host));
        }
        return configurer;
    }

    private HttpClientConfigurer configureHttpProxy(Map<String, Object> parameters, HttpClientConfigurer configurer) {
        String proxyHost = (String)this.getAndRemoveParameter(parameters, "proxyHost", String.class);
        Integer proxyPort = (Integer)this.getAndRemoveParameter(parameters, "proxyPort", Integer.class);
        if (proxyHost != null && proxyPort != null) {
            String proxyUsername = (String)this.getAndRemoveParameter(parameters, "proxyUsername", String.class);
            String proxyPassword = (String)this.getAndRemoveParameter(parameters, "proxyPassword", String.class);
            String proxyDomain = (String)this.getAndRemoveParameter(parameters, "proxyDomain", String.class);
            String proxyNtHost = (String)this.getAndRemoveParameter(parameters, "proxyNtHost", String.class);
            if (proxyUsername != null && proxyPassword != null) {
                return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyHost, proxyPort, proxyUsername, proxyPassword, proxyDomain, proxyNtHost));
            }
            return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyHost, proxyPort));
        }
        return configurer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        X509HostnameVerifier x509HostnameVerifier;
        HttpClientConfigurer httpClientConfigurer;
        String addressUri = uri;
        if (!uri.startsWith("http4:") && !uri.startsWith("https4:")) {
            addressUri = remaining;
        }
        HashMap<String, Object> httpClientParameters = new HashMap<String, Object>(parameters);
        HttpParams clientParams = this.configureHttpParams(parameters);
        this.validateParameters(uri, parameters, "httpClient.");
        HttpBinding httpBinding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        if (httpBinding == null) {
            httpBinding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        }
        if ((httpClientConfigurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurerRef", HttpClientConfigurer.class)) == null) {
            httpClientConfigurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class);
        }
        if ((x509HostnameVerifier = (X509HostnameVerifier)this.resolveAndRemoveReferenceParameter(parameters, "x509HostnameVerifier", X509HostnameVerifier.class)) == null) {
            x509HostnameVerifier = this.x509HostnameVerifier;
        }
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters);
        URI endpointUri = URISupport.createRemainingURI((URI)new URI(addressUri), (Map)CastUtils.cast(httpClientParameters));
        URI httpUri = URISupport.createRemainingURI((URI)new URI(addressUri), (Map)CastUtils.cast(parameters));
        String part = httpUri.getSchemeSpecificPart();
        if (part != null && ((part = part.toLowerCase()).startsWith("//http//") || part.startsWith("//https//") || part.startsWith("//http://") || part.startsWith("//https://"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        boolean secure = this.isSecureConnection(uri);
        int port = HttpComponent.getPort(httpUri);
        this.registerPort(secure, x509HostnameVerifier, port);
        HttpEndpoint endpoint = new HttpEndpoint(endpointUri.toString(), this, httpUri, clientParams, this.clientConnectionManager, configurer);
        this.setProperties((Object)endpoint, parameters);
        this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        endpoint.setBinding(this.getHttpBinding());
        if (httpBinding != null) {
            endpoint.setHttpBinding(httpBinding);
        }
        if (httpClientConfigurer != null) {
            endpoint.setHttpClientConfigurer(httpClientConfigurer);
        }
        return endpoint;
    }

    private static int getPort(URI uri) {
        int port = uri.getPort();
        if (port < 0) {
            if ("http4".equals(uri.getScheme()) || "http".equals(uri.getScheme())) {
                port = 80;
            } else if ("https4".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown scheme, cannot determine port number for uri: " + uri);
            }
        }
        return port;
    }

    protected void registerPort(boolean secure, X509HostnameVerifier x509HostnameVerifier, int port) throws NoSuchAlgorithmException {
        SchemeRegistry registry = this.clientConnectionManager.getSchemeRegistry();
        if (secure) {
            SSLSocketFactory socketFactory = SSLSocketFactory.getSocketFactory();
            socketFactory.setHostnameVerifier(x509HostnameVerifier);
            registry.register(new Scheme("https", port, (SchemeSocketFactory)socketFactory));
            LOG.info("Registering SSL scheme https on port " + port);
            socketFactory = SSLSocketFactory.getSocketFactory();
            socketFactory.setHostnameVerifier(x509HostnameVerifier);
            registry.register(new Scheme("https4", port, (SchemeSocketFactory)socketFactory));
            LOG.info("Registering SSL scheme https4 on port " + port);
        } else {
            registry.register(new Scheme("http", port, (SchemeSocketFactory)new PlainSocketFactory()));
            LOG.info("Registering PLAIN scheme http on port " + port);
            registry.register(new Scheme("http4", port, (SchemeSocketFactory)new PlainSocketFactory()));
            LOG.info("Registering PLAIN scheme http4 on port " + port);
        }
    }

    protected ClientConnectionManager createConnectionManager() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        ThreadSafeClientConnManager answer = new ThreadSafeClientConnManager(schemeRegistry);
        if (this.getMaxTotalConnections() > 0) {
            answer.setMaxTotal(this.getMaxTotalConnections());
        }
        if (this.getConnectionsPerRoute() > 0) {
            answer.setDefaultMaxPerRoute(this.getConnectionsPerRoute());
        }
        LOG.info("Created ClientConnectionManager " + answer);
        return answer;
    }

    protected HttpParams configureHttpParams(Map<String, Object> parameters) throws Exception {
        BasicHttpParams clientParams = new BasicHttpParams();
        AuthParamBean authParamBean = new AuthParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)authParamBean, parameters, (String)"httpClient.");
        ClientParamBean clientParamBean = new ClientParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)clientParamBean, parameters, (String)"httpClient.");
        ConnConnectionParamBean connConnectionParamBean = new ConnConnectionParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)connConnectionParamBean, parameters, (String)"httpClient.");
        ConnRouteParamBean connRouteParamBean = new ConnRouteParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)connRouteParamBean, parameters, (String)"httpClient.");
        CookieSpecParamBean cookieSpecParamBean = new CookieSpecParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)cookieSpecParamBean, parameters, (String)"httpClient.");
        HttpConnectionParamBean httpConnectionParamBean = new HttpConnectionParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)httpConnectionParamBean, parameters, (String)"httpClient.");
        HttpProtocolParamBean httpProtocolParamBean = new HttpProtocolParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)httpProtocolParamBean, parameters, (String)"httpClient.");
        return clientParams;
    }

    private boolean isSecureConnection(String uri) {
        return uri.startsWith("https");
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(ClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public HttpBinding getHttpBinding() {
        return this.httpBinding;
    }

    public void setHttpBinding(HttpBinding httpBinding) {
        this.httpBinding = httpBinding;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getConnectionsPerRoute() {
        return this.connectionsPerRoute;
    }

    public void setConnectionsPerRoute(int connectionsPerRoute) {
        this.connectionsPerRoute = connectionsPerRoute;
    }

    public void doStart() throws Exception {
        super.doStart();
        if (this.clientConnectionManager == null) {
            this.clientConnectionManager = this.createConnectionManager();
        }
    }

    public void doStop() throws Exception {
        if (this.clientConnectionManager != null) {
            LOG.info("Shutting down ClientConnectionManager: " + this.clientConnectionManager);
            this.clientConnectionManager.shutdown();
            this.clientConnectionManager = null;
        }
        super.doStop();
    }
}

