/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.HttpMethods;
import org.apache.camel.component.http4.HttpOperationFailedException;
import org.apache.camel.component.http4.helper.GZIPHelper;
import org.apache.camel.component.http4.helper.HttpHelper;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpProducer.class);
    private HttpClient httpClient;
    private boolean throwException;
    private boolean transferException;

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.getHttpClient();
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.transferException = endpoint.isTransferException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        if (this.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
        }
        HttpRequestBase httpRequest = this.createMethod(exchange);
        Message in = exchange.getIn();
        String httpProtocolVersion = (String)in.getHeader("CamelHttpProtocolVersion", String.class);
        if (httpProtocolVersion != null) {
            httpRequest.getParams().setParameter("http.protocol.version", (Object)HttpHelper.parserHttpVersion(httpProtocolVersion));
        }
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry entry : in.getHeaders().entrySet()) {
            String headerValue = (String)in.getHeader((String)entry.getKey(), String.class);
            if (strategy == null || strategy.applyFilterToCamelHeaders((String)entry.getKey(), (Object)headerValue, exchange)) continue;
            httpRequest.addHeader((String)entry.getKey(), headerValue);
        }
        HttpResponse httpResponse = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing http " + httpRequest.getMethod() + " method: " + httpRequest.getURI().toString());
            }
            httpResponse = this.executeMethod((HttpUriRequest)httpRequest);
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Http responseCode: " + responseCode);
            }
            if (this.throwException && (responseCode < 100 || responseCode >= 300)) {
                throw this.populateHttpOperationFailedException(exchange, httpRequest, httpResponse, responseCode);
            }
            this.populateResponse(exchange, httpRequest, httpResponse, in, strategy, responseCode);
        }
        finally {
            if (httpResponse != null) {
                try {
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                }
                catch (IOException e) {}
            }
        }
    }

    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    protected void populateResponse(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException, ClassNotFoundException {
        Header[] headers;
        Object response = HttpProducer.extractResponseBody(httpRequest, httpResponse, exchange);
        Message answer = exchange.getOut();
        answer.setHeaders(in.getHeaders());
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        answer.setBody(response);
        for (Header header : headers = httpResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
            answer.setHeader(name, (Object)value);
        }
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, int responseCode) throws IOException, ClassNotFoundException {
        Header locationHeader;
        String uri = httpRequest.getURI().toString();
        String statusText = httpResponse.getStatusLine() != null ? httpResponse.getStatusLine().getReasonPhrase() : null;
        Map<String, String> headers = HttpProducer.extractResponseHeaders(httpResponse.getAllHeaders());
        Object responseBody = HttpProducer.extractResponseBody(httpRequest, httpResponse, exchange);
        if (this.transferException && responseBody != null && responseBody instanceof Exception) {
            return (Exception)responseBody;
        }
        String copy = null;
        if (responseBody != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        HttpOperationFailedException answer = (locationHeader = httpResponse.getFirstHeader("location")) != null && responseCode >= 300 && responseCode < 400 ? new HttpOperationFailedException(uri, responseCode, statusText, locationHeader.getValue(), headers, copy) : new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        return answer;
    }

    protected HttpResponse executeMethod(HttpUriRequest httpRequest) throws IOException {
        return this.httpClient.execute(httpRequest);
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return null;
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected static Object extractResponseBody(HttpRequestBase httpRequest, HttpResponse httpResponse, Exchange exchange) throws IOException, ClassNotFoundException {
        String contentEncoding;
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        if (is == null) {
            return null;
        }
        Header header = httpResponse.getFirstHeader("Content-Encoding");
        String string = contentEncoding = header != null ? header.getValue() : null;
        if (!((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            is = GZIPHelper.uncompressGzip(contentEncoding, is);
        }
        String contentType = null;
        header = httpRequest.getFirstHeader("content-type");
        if (header != null) {
            contentType = header.getValue();
            HttpHelper.setCharsetFromContentType(contentType, exchange);
        }
        InputStream response = HttpProducer.doExtractResponseBodyAsStream(is, exchange);
        if (contentType != null && contentType.equals("application/x-java-serialized-object")) {
            return HttpHelper.deserializeJavaObjectFromStream(response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream doExtractResponseBodyAsStream(InputStream is, Exchange exchange) throws IOException {
        try {
            CachedOutputStream cos = new CachedOutputStream(exchange, false);
            IOHelper.copy((InputStream)is, (OutputStream)cos);
            InputStream inputStream = cos.getWrappedInputStream();
            return inputStream;
        }
        finally {
            IOHelper.close((Closeable)is, (String)"Extracting response body", (Logger)LOG);
        }
    }

    protected HttpRequestBase createMethod(Exchange exchange) throws URISyntaxException, CamelExchangeException {
        String url = HttpHelper.createURL(exchange, this.getEndpoint());
        URI uri = new URI(url);
        HttpEntity requestEntity = this.createRequestEntity(exchange);
        HttpMethods methodToUse = HttpHelper.createMethod(exchange, this.getEndpoint(), requestEntity != null);
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = this.getEndpoint().getHttpUri().getRawQuery();
        }
        StringBuilder builder = new StringBuilder(uri.getScheme()).append("://").append(uri.getHost());
        if (uri.getPort() != -1) {
            builder.append(":").append(uri.getPort());
        }
        if (uri.getPath() != null) {
            builder.append(uri.getRawPath());
        }
        if (queryString != null) {
            builder.append('?');
            builder.append(queryString);
        }
        HttpRequestBase httpRequest = methodToUse.createMethod(builder.toString());
        if (methodToUse.isEntityEnclosing()) {
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null && LOG.isDebugEnabled()) {
                LOG.debug("No Content-Type provided for URL: " + url + " with exchange: " + exchange);
            }
        }
        return httpRequest;
    }

    protected HttpEntity createRequestEntity(Exchange exchange) throws CamelExchangeException {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return null;
        }
        HttpEntity answer = (HttpEntity)in.getBody(HttpEntity.class);
        if (answer == null) {
            try {
                Object data = in.getBody();
                if (data != null) {
                    StringEntity entity;
                    String contentType = ExchangeHelper.getContentType((Exchange)exchange);
                    if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
                        Serializable obj = (Serializable)in.getMandatoryBody(Serializable.class);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        HttpHelper.writeObjectToStream(bos, obj);
                        ByteArrayEntity entity2 = new ByteArrayEntity(bos.toByteArray());
                        entity2.setContentType("application/x-java-serialized-object");
                        IOHelper.close((Closeable)bos);
                        answer = entity2;
                    } else if (data instanceof File || data instanceof GenericFile) {
                        File file = (File)in.getBody(File.class);
                        if (file != null) {
                            answer = new FileEntity(file, contentType);
                        }
                    } else if (data instanceof String) {
                        String charset = IOConverter.getCharsetName((Exchange)exchange, (boolean)false);
                        entity = new StringEntity((String)data, charset);
                        entity.setContentType(contentType);
                        answer = entity;
                    }
                    if (answer == null) {
                        InputStream is = (InputStream)in.getMandatoryBody(InputStream.class);
                        entity = new InputStreamEntity(is, -1L);
                        entity.setContentType(contentType);
                        answer = entity;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, (Throwable)e);
            }
            catch (IOException e) {
                throw new CamelExchangeException("Error serializing message body", exchange, (Throwable)e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

