/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;

public enum HttpMethods implements Expression
{
    GET(HttpGet.class),
    POST(HttpPost.class),
    PUT(HttpPut.class),
    DELETE(HttpDelete.class),
    HEAD(HttpHead.class),
    OPTIONS(HttpOptions.class),
    TRACE(HttpTrace.class);

    final Class<? extends HttpRequestBase> clazz;
    final boolean entity;

    private HttpMethods(Class<? extends HttpRequestBase> clazz) {
        this.clazz = clazz;
        this.entity = HttpEntityEnclosingRequestBase.class.isAssignableFrom(clazz);
    }

    public HttpRequestBase createMethod(String url) {
        try {
            return this.clazz.getDeclaredConstructor(String.class).newInstance(url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean isEntityEnclosing() {
        return this.entity;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        return (T)ExpressionBuilder.constantExpression((Object)this.name()).evaluate(exchange, type);
    }
}

