/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.http4.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http4.CompositeHttpConfigurer;
import org.apache.camel.component.http4.HttpBinding;
import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.camel.component.http4.HttpConsumer;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.ProxyHttpClientConfigurer;
import org.apache.camel.component.http4.helper.HttpHelper;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.http.auth.params.AuthParamBean;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnConnectionParamBean;
import org.apache.http.conn.params.ConnRouteParamBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.params.CookieSpecParamBean;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParamBean;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParamBean;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpComponent
extends HeaderFilterStrategyComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpComponent.class);
    protected HttpClientConfigurer httpClientConfigurer;
    protected ClientConnectionManager clientConnectionManager;
    protected HttpBinding httpBinding;
    protected HttpContext httpContext;
    protected SSLContextParameters sslContextParameters;
    protected X509HostnameVerifier x509HostnameVerifier = new BrowserCompatHostnameVerifier();
    protected int maxTotalConnections = 200;
    protected int connectionsPerRoute = 20;

    public void connect(HttpConsumer consumer) throws Exception {
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
    }

    protected HttpClientConfigurer createHttpClientConfigurer(Map<String, Object> parameters, boolean secure) throws Exception {
        HttpClientConfigurer configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurerRef", HttpClientConfigurer.class);
        if (configurer == null && (configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class)) == null) {
            configurer = this.getHttpClientConfigurer();
        }
        configurer = this.configureBasicAuthentication(parameters, configurer);
        configurer = this.configureHttpProxy(parameters, configurer, secure);
        return configurer;
    }

    private HttpClientConfigurer configureBasicAuthentication(Map<String, Object> parameters, HttpClientConfigurer configurer) {
        String authUsername = (String)this.getAndRemoveParameter(parameters, "authUsername", String.class);
        String authPassword = (String)this.getAndRemoveParameter(parameters, "authPassword", String.class);
        if (authUsername != null && authPassword != null) {
            String authDomain = (String)this.getAndRemoveParameter(parameters, "authDomain", String.class);
            String authHost = (String)this.getAndRemoveParameter(parameters, "authHost", String.class);
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(authUsername, authPassword, authDomain, authHost));
        }
        return configurer;
    }

    private HttpClientConfigurer configureHttpProxy(Map<String, Object> parameters, HttpClientConfigurer configurer, boolean secure) throws Exception {
        String proxyAuthScheme = (String)this.getAndRemoveParameter(parameters, "proxyAuthScheme", String.class);
        if (proxyAuthScheme == null) {
            proxyAuthScheme = secure ? "https" : "http";
        }
        String proxyAuthHost = (String)this.getAndRemoveParameter(parameters, "proxyAuthHost", String.class);
        Integer proxyAuthPort = (Integer)this.getAndRemoveParameter(parameters, "proxyAuthPort", Integer.class);
        if (proxyAuthHost != null && proxyAuthPort != null) {
            String proxyAuthUsername = (String)this.getAndRemoveParameter(parameters, "proxyAuthUsername", String.class);
            String proxyAuthPassword = (String)this.getAndRemoveParameter(parameters, "proxyAuthPassword", String.class);
            String proxyAuthDomain = (String)this.getAndRemoveParameter(parameters, "proxyAuthDomain", String.class);
            String proxyAuthNtHost = (String)this.getAndRemoveParameter(parameters, "proxyAuthNtHost", String.class);
            boolean secureProxy = HttpHelper.isSecureConnection(proxyAuthScheme);
            this.registerPort(secureProxy, this.x509HostnameVerifier, proxyAuthPort, this.sslContextParameters);
            if (proxyAuthUsername != null && proxyAuthPassword != null) {
                return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme, proxyAuthUsername, proxyAuthPassword, proxyAuthDomain, proxyAuthNtHost));
            }
            return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme));
        }
        return configurer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        URI httpUri;
        String part;
        SSLContextParameters sslContextParameters;
        X509HostnameVerifier x509HostnameVerifier;
        HttpContext httpContext;
        HttpClientConfigurer httpClientConfigurer;
        String addressUri = uri;
        if (!uri.startsWith("http4:") && !uri.startsWith("https4:")) {
            addressUri = remaining;
        }
        HashMap<String, Object> httpClientParameters = new HashMap<String, Object>(parameters);
        HttpParams clientParams = this.configureHttpParams(parameters);
        this.validateParameters(uri, parameters, "httpClient.");
        HttpBinding httpBinding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        if (httpBinding == null) {
            httpBinding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        }
        if ((httpClientConfigurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurerRef", HttpClientConfigurer.class)) == null) {
            httpClientConfigurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class);
        }
        if ((httpContext = (HttpContext)this.resolveAndRemoveReferenceParameter(parameters, "httpContextRef", HttpContext.class)) == null) {
            httpContext = (HttpContext)this.resolveAndRemoveReferenceParameter(parameters, "httpContext", HttpContext.class);
        }
        if ((x509HostnameVerifier = (X509HostnameVerifier)this.resolveAndRemoveReferenceParameter(parameters, "x509HostnameVerifier", X509HostnameVerifier.class)) == null) {
            x509HostnameVerifier = this.getX509HostnameVerifier();
        }
        if ((sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParametersRef", SSLContextParameters.class)) == null) {
            sslContextParameters = this.getSslContextParameters();
        }
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        boolean secure = HttpHelper.isSecureConnection(uri);
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, secure);
        URI endpointUri = URISupport.createRemainingURI((URI)new URI(addressUri), (Map)CastUtils.cast(httpClientParameters));
        HttpEndpoint endpoint = new HttpEndpoint(endpointUri.toString(), this, clientParams, this.clientConnectionManager, configurer);
        this.setProperties((Object)endpoint, parameters);
        String httpUriAddress = addressUri;
        if (addressUri.startsWith("http4")) {
            httpUriAddress = "http" + addressUri.substring(5);
        }
        if (addressUri.startsWith("https4")) {
            httpUriAddress = "https" + addressUri.substring(6);
        }
        if ((part = (httpUri = URISupport.createRemainingURI((URI)new URI(httpUriAddress), (Map)CastUtils.cast(parameters))).getSchemeSpecificPart()) != null && ((part = part.toLowerCase()).startsWith("//http//") || part.startsWith("//https//") || part.startsWith("//http://") || part.startsWith("//https://"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        endpoint.setHttpUri(httpUri);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        endpoint.setBinding(this.getHttpBinding());
        if (httpBinding != null) {
            endpoint.setHttpBinding(httpBinding);
        }
        if (httpClientConfigurer != null) {
            endpoint.setHttpClientConfigurer(httpClientConfigurer);
        }
        endpoint.setHttpContext(this.getHttpContext());
        if (httpContext != null) {
            endpoint.setHttpContext(httpContext);
        }
        int port = HttpComponent.getPort(httpUri);
        this.registerPort(secure, x509HostnameVerifier, port, sslContextParameters);
        return endpoint;
    }

    private static int getPort(URI uri) {
        int port = uri.getPort();
        if (port < 0) {
            if ("http4".equals(uri.getScheme()) || "http".equals(uri.getScheme())) {
                port = 80;
            } else if ("https4".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown scheme, cannot determine port number for uri: " + uri);
            }
        }
        return port;
    }

    protected void registerPort(boolean secure, X509HostnameVerifier x509HostnameVerifier, int port, SSLContextParameters sslContextParams) throws Exception {
        SchemeRegistry registry = this.clientConnectionManager.getSchemeRegistry();
        if (secure) {
            SSLSocketFactory socketFactory = sslContextParams == null ? SSLSocketFactory.getSocketFactory() : new SSLSocketFactory(sslContextParams.createSSLContext());
            socketFactory.setHostnameVerifier(x509HostnameVerifier);
            registry.register(new Scheme("https", port, (SchemeSocketFactory)socketFactory));
            LOG.info("Registering SSL scheme https on port " + port);
            registry.register(new Scheme("https4", port, (SchemeSocketFactory)socketFactory));
            LOG.info("Registering SSL scheme https4 on port " + port);
        } else {
            registry.register(new Scheme("http", port, (SchemeSocketFactory)new PlainSocketFactory()));
            LOG.info("Registering PLAIN scheme http on port " + port);
            registry.register(new Scheme("http4", port, (SchemeSocketFactory)new PlainSocketFactory()));
            LOG.info("Registering PLAIN scheme http4 on port " + port);
        }
    }

    protected ClientConnectionManager createConnectionManager() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        ThreadSafeClientConnManager answer = new ThreadSafeClientConnManager(schemeRegistry);
        if (this.getMaxTotalConnections() > 0) {
            answer.setMaxTotal(this.getMaxTotalConnections());
        }
        if (this.getConnectionsPerRoute() > 0) {
            answer.setDefaultMaxPerRoute(this.getConnectionsPerRoute());
        }
        LOG.info("Created ClientConnectionManager " + answer);
        return answer;
    }

    protected HttpParams configureHttpParams(Map<String, Object> parameters) throws Exception {
        BasicHttpParams clientParams = new BasicHttpParams();
        AuthParamBean authParamBean = new AuthParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)authParamBean, parameters, (String)"httpClient.");
        ClientParamBean clientParamBean = new ClientParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)clientParamBean, parameters, (String)"httpClient.");
        ConnConnectionParamBean connConnectionParamBean = new ConnConnectionParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)connConnectionParamBean, parameters, (String)"httpClient.");
        ConnRouteParamBean connRouteParamBean = new ConnRouteParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)connRouteParamBean, parameters, (String)"httpClient.");
        CookieSpecParamBean cookieSpecParamBean = new CookieSpecParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)cookieSpecParamBean, parameters, (String)"httpClient.");
        HttpConnectionParamBean httpConnectionParamBean = new HttpConnectionParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)httpConnectionParamBean, parameters, (String)"httpClient.");
        HttpProtocolParamBean httpProtocolParamBean = new HttpProtocolParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)httpProtocolParamBean, parameters, (String)"httpClient.");
        return clientParams;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(ClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public HttpBinding getHttpBinding() {
        return this.httpBinding;
    }

    public void setHttpBinding(HttpBinding httpBinding) {
        this.httpBinding = httpBinding;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public X509HostnameVerifier getX509HostnameVerifier() {
        return this.x509HostnameVerifier;
    }

    public void setX509HostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        this.x509HostnameVerifier = x509HostnameVerifier;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getConnectionsPerRoute() {
        return this.connectionsPerRoute;
    }

    public void setConnectionsPerRoute(int connectionsPerRoute) {
        this.connectionsPerRoute = connectionsPerRoute;
    }

    public void doStart() throws Exception {
        super.doStart();
        if (this.clientConnectionManager == null) {
            this.clientConnectionManager = this.createConnectionManager();
        }
    }

    public void doStop() throws Exception {
        if (this.clientConnectionManager != null) {
            LOG.info("Shutting down ClientConnectionManager: " + this.clientConnectionManager);
            this.clientConnectionManager.shutdown();
            this.clientConnectionManager = null;
        }
        super.doStop();
    }
}

