/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.iam;

import com.huaweicloud.sdk.core.auth.GlobalCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.iam.v3.IamClient;
import com.huaweicloud.sdk.iam.v3.region.IamRegion;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.huaweicloud.iam.IAMComponent;
import org.apache.camel.component.huaweicloud.iam.IAMProducer;
import org.apache.camel.component.huaweicloud.iam.models.ServiceKeys;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.11.0", scheme="hwcloud-iam", title="Huawei Cloud Identity and Access Management (IAM)", syntax="hwcloud-iam:operation", category={Category.CLOUD}, producerOnly=true)
public class IAMEndpoint
extends DefaultEndpoint {
    @UriPath(description="Operation to be performed", displayName="Operation", label="producer", secret=false)
    @Metadata(required=true)
    private String operation;
    @UriParam(description="IAM service region", displayName="Service region", secret=false)
    @Metadata(required=true)
    private String region;
    @UriParam(description="Proxy server ip/hostname", displayName="Proxy server host", secret=false)
    @Metadata(required=false)
    private String proxyHost;
    @UriParam(description="Proxy server port", displayName="Proxy server port", secret=false)
    @Metadata(required=false)
    private int proxyPort;
    @UriParam(description="Proxy authentication user", displayName="Proxy user", secret=true)
    @Metadata(required=false)
    private String proxyUser;
    @UriParam(description="Proxy authentication password", displayName="Proxy password", secret=true)
    @Metadata(required=false)
    private String proxyPassword;
    @UriParam(description="Ignore SSL verification", displayName="SSL Verification Ignored", secret=false, defaultValue="false")
    @Metadata(required=false)
    private boolean ignoreSslVerification;
    @UriParam(description="Configuration object for cloud service authentication", displayName="Service Configuration", secret=true)
    @Metadata(required=false)
    private ServiceKeys serviceKeys;
    @UriParam(description="Authentication key for the cloud user", displayName="API authentication key (AK)", secret=true)
    @Metadata(required=true)
    private String authenticationKey;
    @UriParam(description="Secret key for the cloud user", displayName="API secret key (SK)", secret=true)
    @Metadata(required=true)
    private String secretKey;
    @UriParam(description="User ID to perform operation with", displayName="User ID", secret=true)
    @Metadata(required=false)
    private String userId;
    @UriParam(description="Group ID to perform operation with", displayName="Group ID", secret=true)
    @Metadata(required=false)
    private String groupId;
    private IamClient iamClient;

    public IAMEndpoint() {
    }

    public IAMEndpoint(String uri, String operation, IAMComponent component) {
        super(uri, (Component)component);
        this.operation = operation;
    }

    public Producer createProducer() throws Exception {
        return new IAMProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isIgnoreSslVerification() {
        return this.ignoreSslVerification;
    }

    public void setIgnoreSslVerification(boolean ignoreSslVerification) {
        this.ignoreSslVerification = ignoreSslVerification;
    }

    public ServiceKeys getServiceKeys() {
        return this.serviceKeys;
    }

    public void setServiceKeys(ServiceKeys serviceKeys) {
        this.serviceKeys = serviceKeys;
    }

    public String getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public IamClient getIamClient() {
        return this.iamClient;
    }

    public void setIamClient(IamClient iamClient) {
        this.iamClient = iamClient;
    }

    public IamClient initClient() {
        if (this.iamClient != null) {
            return this.iamClient;
        }
        if (ObjectHelper.isEmpty((Object)this.getServiceKeys()) && ObjectHelper.isEmpty((Object)this.getAuthenticationKey())) {
            throw new IllegalArgumentException("Authentication parameter 'authentication key (AK)' not found");
        }
        if (ObjectHelper.isEmpty((Object)this.getServiceKeys()) && ObjectHelper.isEmpty((Object)this.getSecretKey())) {
            throw new IllegalArgumentException("Authentication parameter 'secret key (SK)' not found");
        }
        GlobalCredentials auth = (GlobalCredentials)((GlobalCredentials)new GlobalCredentials().withAk(this.getServiceKeys() != null ? this.getServiceKeys().getAuthenticationKey() : this.getAuthenticationKey())).withSk(this.getServiceKeys() != null ? this.getServiceKeys().getSecretKey() : this.getSecretKey());
        HttpConfig httpConfig = HttpConfig.getDefaultHttpConfig();
        httpConfig.withIgnoreSSLVerification(this.isIgnoreSslVerification());
        if (ObjectHelper.isNotEmpty((Object)this.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.getProxyPort())) {
            httpConfig.withProxyHost(this.getProxyHost()).withProxyPort(this.getProxyPort());
            if (ObjectHelper.isNotEmpty((Object)this.getProxyUser())) {
                httpConfig.withProxyUsername(this.getProxyUser());
                if (ObjectHelper.isNotEmpty((Object)this.getProxyPassword())) {
                    httpConfig.withProxyPassword(this.getProxyPassword());
                }
            }
        }
        if (ObjectHelper.isNotEmpty((Object)this.getRegion())) {
            return (IamClient)IamClient.newBuilder().withCredential((ICredential)auth).withHttpConfig(httpConfig).withRegion(IamRegion.valueOf((String)this.getRegion())).build();
        }
        throw new IllegalArgumentException("Region not found");
    }
}

