/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.obs;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class OBSEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":operation";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "hwcloud-obs".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "operation", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(42);
        props.add("backoffMultiplier");
        props.add("bucketName");
        props.add("destinationBucket");
        props.add("fileName");
        props.add("serviceKeys");
        props.add("prefix");
        props.add("bucketLocation");
        props.add("ignoreSslVerification");
        props.add("initialDelay");
        props.add("scheduler");
        props.add("proxyPort");
        props.add("endpoint");
        props.add("bridgeErrorHandler");
        props.add("useFixedDelay");
        props.add("runLoggingLevel");
        props.add("delimiter");
        props.add("backoffErrorThreshold");
        props.add("greedy");
        props.add("maxMessagesPerPoll");
        props.add("scheduledExecutorService");
        props.add("repeatCount");
        props.add("timeUnit");
        props.add("secretKey");
        props.add("moveAfterRead");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("exchangePattern");
        props.add("proxyPassword");
        props.add("includeFolders");
        props.add("proxyHost");
        props.add("backoffIdleThreshold");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("pollStrategy");
        props.add("startScheduler");
        props.add("accessKey");
        props.add("deleteAfterRead");
        props.add("proxyUser");
        props.add("objectName");
        props.add("region");
        props.add("operation");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(5);
        secretProps.add("serviceKeys");
        secretProps.add("secretKey");
        secretProps.add("accessKey");
        secretProps.add("proxyPassword");
        secretProps.add("proxyUser");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

