/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.obs;

import com.obs.services.model.ObsObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.IOHelper;

public final class OBSUtils {
    private OBSUtils() {
    }

    public static byte[] toBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copy((InputStream)IOHelper.buffered((InputStream)stream), (OutputStream)bos);
        return bos.toByteArray();
    }

    public static void mapObsObject(Exchange exchange, ObsObject obsObject) {
        Message message = exchange.getIn();
        try {
            message.setBody((Object)OBSUtils.toBytes(obsObject.getObjectContent()));
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        message.setHeader("CamelHwCloudObsBucketName", (Object)obsObject.getBucketName());
        message.setHeader("CamelHwCloudObsObjectKey", (Object)obsObject.getObjectKey());
        message.setHeader("CamelHwCloudObsLastModified", (Object)obsObject.getMetadata().getLastModified());
        message.setHeader("Content-Length", (Object)obsObject.getMetadata().getContentLength());
        message.setHeader("Content-Type", (Object)obsObject.getMetadata().getContentType());
        message.setHeader("CamelHwCloudObsETag", (Object)obsObject.getMetadata().getEtag());
        message.setHeader("CamelHwCloudObsContentMD5", (Object)obsObject.getMetadata().getContentMd5());
        message.setHeader("CamelFileName", (Object)obsObject.getObjectKey());
        if (obsObject.getObjectKey().endsWith("/")) {
            message.setHeader("CamelHwCloudObsObjectType", (Object)"folder");
        } else {
            message.setHeader("CamelHwCloudObsObjectType", (Object)"file");
        }
    }
}

