/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.smn;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.smn.v2.SmnClient;
import com.huaweicloud.sdk.smn.v2.model.PublishMessageRequest;
import com.huaweicloud.sdk.smn.v2.model.PublishMessageRequestBody;
import com.huaweicloud.sdk.smn.v2.model.PublishMessageResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.huaweicloud.smn.SimpleNotificationEndpoint;
import org.apache.camel.component.huaweicloud.smn.SimpleNotificationUtils;
import org.apache.camel.component.huaweicloud.smn.models.ClientConfigurations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleNotificationProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleNotificationProducer.class);
    private SmnClient smnClient;
    private ClientConfigurations clientConfigurations;

    public SimpleNotificationProducer(SimpleNotificationEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.validateAndInitializeSmnClient((SimpleNotificationEndpoint)super.getEndpoint());
    }

    public void process(Exchange exchange) throws Exception {
        block11: {
            block10: {
                String service = ((SimpleNotificationEndpoint)super.getEndpoint()).getSmnService();
                if (ObjectHelper.isEmpty((Object)service)) break block10;
                switch (service) {
                    case "publishMessageService": {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Using message publishing service");
                        }
                        this.performPublishMessageServiceOperations((SimpleNotificationEndpoint)super.getEndpoint(), exchange);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Completed publishing message");
                            break;
                        }
                        break block11;
                    }
                    default: {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Unsupported service name {}", (Object)service);
                        }
                        throw new UnsupportedOperationException(String.format("service %s is not a supported service", service));
                    }
                }
                break block11;
            }
            if (LOG.isErrorEnabled()) {
                LOG.error("Service name is null/empty");
            }
            throw new IllegalStateException("service name cannot be null/empty");
        }
    }

    private void performPublishMessageServiceOperations(SimpleNotificationEndpoint endpoint, Exchange exchange) {
        PublishMessageResponse response;
        this.clientConfigurations = this.validateServiceConfigurations(endpoint, exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking operation name");
        }
        switch (this.clientConfigurations.getOperation()) {
            case "publishAsTextMessage": {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Publishing as text message");
                }
                PublishMessageRequestBody apiBody = new PublishMessageRequestBody().withMessage((String)exchange.getMessage().getBody(String.class)).withSubject(this.clientConfigurations.getSubject()).withTimeToLive(String.valueOf(this.clientConfigurations.getMessageTtl()));
                response = this.smnClient.publishMessage(new PublishMessageRequest().withBody(apiBody).withTopicUrn(this.clientConfigurations.getTopicUrn()));
                break;
            }
            case "publishAsTemplatedMessage": {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Publishing as templated message");
                }
                PublishMessageRequestBody apiBody = new PublishMessageRequestBody().withMessage((String)exchange.getMessage().getBody(String.class)).withSubject(this.clientConfigurations.getSubject()).withTimeToLive(String.valueOf(this.clientConfigurations.getMessageTtl())).withMessageTemplateName((String)exchange.getProperty("CamelHwCloudSmnTemplateName")).withTags((Map)((HashMap)exchange.getProperty("CamelHwCloudSmnTemplateTags"))).withTimeToLive(String.valueOf(this.clientConfigurations.getMessageTtl()));
                response = this.smnClient.publishMessage(new PublishMessageRequest().withBody(apiBody).withTopicUrn(this.clientConfigurations.getTopicUrn()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("operation %s not supported in publishMessage service", this.clientConfigurations.getOperation()));
            }
        }
        this.setResponseParameters(exchange, response);
    }

    private void setResponseParameters(Exchange exchange, PublishMessageResponse response) {
        if (response == null) {
            return;
        }
        if (!ObjectHelper.isEmpty((Object)response.getMessageId())) {
            exchange.setProperty("CamelHwCloudSmnMesssageId", (Object)response.getMessageId());
        }
        if (!ObjectHelper.isEmpty((Object)response.getRequestId())) {
            exchange.setProperty("CamelHwCloudSmnRequestId", (Object)response.getRequestId());
        }
    }

    private void validateAndInitializeSmnClient(SimpleNotificationEndpoint simpleNotificationEndpoint) {
        if (simpleNotificationEndpoint.getSmnClient() != null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Instance of SmnClient was set on the endpoint. Skipping creation of SmnClient from endpoint parameters");
            }
            this.smnClient = simpleNotificationEndpoint.getSmnClient();
            return;
        }
        this.clientConfigurations = new ClientConfigurations();
        if (ObjectHelper.isEmpty((Object)simpleNotificationEndpoint.getSecretKey()) && ObjectHelper.isEmpty((Object)simpleNotificationEndpoint.getServiceKeys())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("secret key (SK) not found");
            }
            throw new IllegalArgumentException("authentication parameter 'secret key (SK)' not found");
        }
        this.clientConfigurations.setSecretKey(simpleNotificationEndpoint.getSecretKey() != null ? simpleNotificationEndpoint.getSecretKey() : simpleNotificationEndpoint.getServiceKeys().getSecretKey());
        if (ObjectHelper.isEmpty((Object)simpleNotificationEndpoint.getAuthKey()) && ObjectHelper.isEmpty((Object)simpleNotificationEndpoint.getServiceKeys())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("authentication key (AK) not found");
            }
            throw new IllegalArgumentException("authentication parameter 'authentication key (AK)' not found");
        }
        this.clientConfigurations.setAuthenticationkey(simpleNotificationEndpoint.getAuthKey() != null ? simpleNotificationEndpoint.getAuthKey() : simpleNotificationEndpoint.getServiceKeys().getAuthenticationKey());
        if (ObjectHelper.isEmpty((Object)simpleNotificationEndpoint.getProjectId())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Project ID not found");
            }
            throw new IllegalArgumentException("project ID not found");
        }
        this.clientConfigurations.setProjectId(simpleNotificationEndpoint.getProjectId());
        String endpointUrl = SimpleNotificationUtils.resolveSmnServiceEndpoint(simpleNotificationEndpoint.getRegion());
        if (endpointUrl == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Valid region not found");
            }
            throw new IllegalArgumentException("enter a valid region");
        }
        this.clientConfigurations.setServiceEndpoint(endpointUrl);
        boolean ignoreSslVerification = simpleNotificationEndpoint.isIgnoreSslVerification();
        if (ignoreSslVerification) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("SSL verification is ignored. This is unsafe in production environment");
            }
            this.clientConfigurations.setIgnoreSslVerification(ignoreSslVerification);
        }
        if (simpleNotificationEndpoint.getProxyHost() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading http proxy configurations");
            }
            this.clientConfigurations.setProxyHost(simpleNotificationEndpoint.getProxyHost());
            this.clientConfigurations.setProxyPort(simpleNotificationEndpoint.getProxyPort());
            this.clientConfigurations.setProxyUser(simpleNotificationEndpoint.getProxyUser());
            this.clientConfigurations.setProxyPassword(simpleNotificationEndpoint.getProxyPassword());
        }
        this.smnClient = this.initializeClient(this.clientConfigurations);
    }

    private SmnClient initializeClient(ClientConfigurations clientConfigurations) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing Smn client");
        }
        HttpConfig httpConfig = null;
        if (clientConfigurations.getProxyHost() != null) {
            httpConfig = HttpConfig.getDefaultHttpConfig();
            httpConfig.withProxyHost(clientConfigurations.getProxyHost()).withProxyPort(clientConfigurations.getProxyPort()).setIgnoreSSLVerification(clientConfigurations.isIgnoreSslVerification());
            if (clientConfigurations.getProxyUser() != null) {
                httpConfig.withProxyUsername(clientConfigurations.getProxyUser());
                httpConfig.withProxyPassword(clientConfigurations.getProxyPassword());
            }
        }
        BasicCredentials credentials = ((BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(clientConfigurations.getAuthenticationkey())).withSk(clientConfigurations.getSecretKey())).withProjectId(clientConfigurations.getProjectId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building Smn client");
        }
        SmnClient smnClient = (SmnClient)SmnClient.newBuilder().withCredential((ICredential)credentials).withHttpConfig(httpConfig).withEndpoint(clientConfigurations.getServiceEndpoint()).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully initialized Smn client");
        }
        return smnClient;
    }

    private ClientConfigurations validateServiceConfigurations(SimpleNotificationEndpoint simpleNotificationEndpoint, Exchange exchange) {
        ClientConfigurations clientConfigurations = new ClientConfigurations();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting exchange body");
        }
        if (ObjectHelper.isEmpty((Object)exchange.getMessage().getBody()) && simpleNotificationEndpoint.getOperation().equals("publishAsTextMessage")) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Found null/empty body. Cannot perform publish as text operation");
            }
            throw new IllegalArgumentException("exchange body cannot be null / empty");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting operation name");
        }
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudSmnOperation")) && ObjectHelper.isEmpty((Object)simpleNotificationEndpoint.getOperation())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Found null/empty operation name. Cannot proceed with Smn operations");
            }
            throw new IllegalArgumentException("operation name not found");
        }
        clientConfigurations.setOperation(exchange.getProperty("CamelHwCloudSmnOperation") != null ? (String)exchange.getProperty("CamelHwCloudSmnOperation") : simpleNotificationEndpoint.getOperation());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting topic name");
        }
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudSmnTopic"))) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Found null/empty topic name");
            }
            throw new IllegalArgumentException("topic name not found");
        }
        clientConfigurations.setTopicUrn(String.format("urn:smn:%s:%s:%s", simpleNotificationEndpoint.getRegion(), simpleNotificationEndpoint.getProjectId(), exchange.getProperty("CamelHwCloudSmnTopic")));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting notification subject value");
        }
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudSmnSubject"))) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("notification subject not found. defaulting to 'DEFAULT_SUBJECT'");
            }
            clientConfigurations.setSubject("DEFAULT_SUBJECT");
        } else {
            clientConfigurations.setSubject((String)exchange.getProperty("CamelHwCloudSmnSubject"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting TTL");
        }
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudSmnMessageTtl"))) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("TTL not found. defaulting to default value {}", (Object)simpleNotificationEndpoint.getMessageTtl());
            }
            clientConfigurations.setMessageTtl(simpleNotificationEndpoint.getMessageTtl());
        } else {
            clientConfigurations.setMessageTtl((Integer)exchange.getProperty("CamelHwCloudSmnMessageTtl"));
        }
        return clientConfigurations;
    }
}

