/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.smn;

import com.huaweicloud.sdk.smn.v2.region.SmnRegion;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleNotificationUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)SimpleNotificationUtils.class.getName());

    private SimpleNotificationUtils() {
    }

    public static String resolveSmnServiceEndpoint(String region) {
        if (region == null || StringUtils.isEmpty((CharSequence)region)) {
            return null;
        }
        String result = SmnRegion.valueOf((String)region).getEndpoint();
        if (LOG.isDebugEnabled()) {
            LOG.debug("endpoint resolved as {} for region {}", (Object)result, (Object)region);
        }
        if (ObjectHelper.isEmpty((String)result)) {
            LOG.error("Couldn't resolve endpoint for region :  {}", (Object)region);
            result = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.info("Returning endpoint {} for region {}", (Object)result, (Object)region);
        }
        return result;
    }
}

