/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import io.nessus.aries.util.AssertState;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.aries.api.issue_credential_v1.IssueCredentialRecordsFilter;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialFreeOfferRequest;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialIssueRequest;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialOfferRequest;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialProposalRequest;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialStoreRequest;

public class IssueCredentialV1ServiceHandler
extends AbstractServiceHandler {
    public IssueCredentialV1ServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(Exchange exchange, String service) throws Exception {
        if (service.equals("/issue-credential/create-offer")) {
            V1CredentialFreeOfferRequest reqObj = this.assertBody(exchange, V1CredentialFreeOfferRequest.class);
            V1CredentialExchange resObj = (V1CredentialExchange)this.createClient().issueCredentialCreateOffer(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else if (service.equals("/issue-credential/send-offer")) {
            V1CredentialOfferRequest reqObj = this.assertBody(exchange, V1CredentialOfferRequest.class);
            V1CredentialExchange resObj = (V1CredentialExchange)this.createClient().issueCredentialSendOffer(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else if (service.equals("/issue-credential/send-proposal")) {
            V1CredentialProposalRequest reqObj = this.assertBody(exchange, V1CredentialProposalRequest.class);
            V1CredentialExchange resObj = (V1CredentialExchange)this.createClient().issueCredentialSendProposal(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else if (service.equals("/issue-credential/records")) {
            IssueCredentialRecordsFilter reqObj = this.assertBody(exchange, IssueCredentialRecordsFilter.class);
            List resObj = (List)this.createClient().issueCredentialRecords(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else {
            if (!service.startsWith("/issue-credential/records/")) throw new UnsupportedServiceException(service);
            String credExchangeId = this.getServicePathToken(service, 2);
            AssertState.notNull((Object)credExchangeId, (String)"Null cred_ex_id");
            if (service.endsWith("/send-request")) {
                V1CredentialExchange resObj = (V1CredentialExchange)this.createClient().issueCredentialRecordsSendRequest(credExchangeId).get();
                exchange.getIn().setBody((Object)resObj);
                return;
            } else if (service.endsWith("/issue")) {
                V1CredentialIssueRequest reqObj = this.maybeHeader(exchange, V1CredentialIssueRequest.class);
                V1CredentialExchange resObj = (V1CredentialExchange)this.createClient().issueCredentialRecordsIssue(credExchangeId, reqObj).get();
                exchange.getIn().setBody((Object)resObj);
                return;
            } else if (service.endsWith("/store")) {
                V1CredentialStoreRequest reqObj = this.maybeBody(exchange, V1CredentialStoreRequest.class);
                V1CredentialExchange resObj = (V1CredentialExchange)this.createClient().issueCredentialRecordsStore(credExchangeId, reqObj).get();
                exchange.getIn().setBody((Object)resObj);
                return;
            } else {
                if (!service.endsWith(credExchangeId)) throw new UnsupportedServiceException(service);
                V1CredentialExchange resObj = this.createClient().issueCredentialRecordsGetById(credExchangeId).orElse(null);
                exchange.getIn().setBody((Object)resObj);
            }
        }
    }
}

