/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.aries.api.present_proof.PresentProofProposal;
import org.hyperledger.aries.api.present_proof.PresentProofRequest;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof.PresentationRequest;
import org.hyperledger.aries.api.present_proof.PresentationRequestCredentialsFilter;

public class PresentProofServiceHandler
extends AbstractServiceHandler {
    public PresentProofServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(Exchange exchange, String service) throws Exception {
        if (service.equals("/present-proof/create-request")) {
            PresentProofRequest reqObj = this.assertBody(exchange, PresentProofRequest.class);
            PresentationExchangeRecord resObj = (PresentationExchangeRecord)this.createClient().presentProofCreateRequest(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else if (service.equals("/present-proof/send-proposal")) {
            PresentProofProposal reqObj = this.assertBody(exchange, PresentProofProposal.class);
            PresentationExchangeRecord resObj = (PresentationExchangeRecord)this.adminClient().presentProofSendProposal(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else if (service.equals("/present-proof/send-request")) {
            PresentProofRequest reqObj = this.assertBody(exchange, PresentProofRequest.class);
            PresentationExchangeRecord resObj = (PresentationExchangeRecord)this.createClient().presentProofSendRequest(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
            return;
        } else if (service.equals("/present-proof/records")) {
            List resObj = this.createClient().presentProofRecords().orElse(Collections.emptyList()).stream().sorted(Collections.reverseOrder((a, b) -> a.getState().ordinal() - b.getState().ordinal())).peek(pe -> this.log.info("{}", pe)).collect(Collectors.toList());
            exchange.getIn().setBody(resObj);
            return;
        } else {
            if (!service.startsWith("/present-proof/records/")) throw new UnsupportedServiceException(service);
            String presExchangeId = this.getServicePathToken(service, 2);
            if (service.endsWith("/credentials")) {
                PresentationRequestCredentialsFilter reqObj = this.assertBody(exchange, PresentationRequestCredentialsFilter.class);
                List resObj = this.createClient().presentProofRecordsCredentials(presExchangeId, reqObj).orElse(Collections.emptyList());
                exchange.getIn().setBody(resObj);
                return;
            } else if (service.endsWith("/send-presentation")) {
                PresentationRequest reqObj = this.assertBody(exchange, PresentationRequest.class);
                PresentationExchangeRecord resObj = (PresentationExchangeRecord)this.createClient().presentProofRecordsSendPresentation(presExchangeId, reqObj).get();
                exchange.getIn().setBody((Object)resObj);
                return;
            } else if (service.endsWith("/verify-presentation")) {
                PresentationExchangeRecord resObj = (PresentationExchangeRecord)this.createClient().presentProofRecordsVerifyPresentation(presExchangeId).get();
                exchange.getIn().setBody((Object)resObj);
                return;
            } else {
                if (!service.endsWith(presExchangeId)) throw new UnsupportedServiceException(service);
                PresentationExchangeRecord resObj = this.createClient().presentProofRecordsGetById(presExchangeId).orElse(null);
                exchange.getIn().setBody((Object)resObj);
            }
        }
    }
}

