/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries;

import io.nessus.aries.AgentConfiguration;
import io.nessus.aries.AriesClientFactory;
import io.nessus.aries.util.AssertArg;
import io.nessus.aries.util.AssertState;
import io.nessus.aries.wallet.NessusWallet;
import io.nessus.aries.wallet.WalletRegistry;
import io.nessus.aries.websocket.WebSocketClient;
import io.nessus.aries.websocket.WebSocketListener;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aries.HyperledgerAriesConfiguration;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.api.multitenancy.WalletRecord;

@Component(value="hyperledger-aries")
public class HyperledgerAriesComponent
extends DefaultComponent {
    private final WalletRegistry walletRegistry = new WalletRegistry(new NessusWallet[0]);
    private AgentConfiguration agentConfig;
    @Metadata(description="Remove wallets from the Agent on shutdown")
    private boolean removeWalletsOnShutdown;
    private AriesClient adminClient;
    private WebSocketClient adminWebSocketClient;
    private WebSocketListener adminWebSocketListener;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HyperledgerAriesConfiguration configuration = new HyperledgerAriesConfiguration();
        configuration.setWalletName(remaining);
        HyperledgerAriesEndpoint endpoint = new HyperledgerAriesEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public boolean isRemoveWalletsOnShutdown() {
        return this.removeWalletsOnShutdown;
    }

    public void setRemoveWalletsOnShutdown(boolean removeWalletsOnShutdown) {
        this.removeWalletsOnShutdown = removeWalletsOnShutdown;
    }

    protected void doShutdown() throws Exception {
        this.closeAdminWebSocketClient();
        if (this.removeWalletsOnShutdown) {
            for (NessusWallet wallet : this.walletRegistry.getWallets()) {
                wallet.closeAndRemove();
            }
        }
    }

    public AgentConfiguration getAgentConfiguration() {
        if (this.agentConfig == null) {
            this.agentConfig = AgentConfiguration.defaultConfiguration();
        }
        return this.agentConfig;
    }

    public void setAgentConfiguration(AgentConfiguration agentConfig) {
        this.agentConfig = agentConfig;
    }

    public WalletRegistry getWalletRegistry() {
        return this.walletRegistry;
    }

    public List<String> getWalletNames() {
        return this.walletRegistry.getWalletNames();
    }

    public void addWallet(NessusWallet wallet) {
        this.walletRegistry.putWallet(wallet);
    }

    public NessusWallet getWallet(String walletName) {
        return this.walletRegistry.getWalletByName(walletName);
    }

    public NessusWallet assertWallet(String walletName) {
        NessusWallet wallet = this.getWallet(walletName);
        AssertState.notNull((Object)wallet, (String)("Cannot obtain wallet for: " + walletName));
        return wallet;
    }

    public AriesClient adminClient() {
        if (this.adminClient == null) {
            AgentConfiguration agentConfig = this.getAgentConfiguration();
            this.adminClient = AriesClientFactory.adminClient((AgentConfiguration)agentConfig);
        }
        return this.adminClient;
    }

    public AriesClient createClient(String walletName) {
        NessusWallet wallet = this.assertWallet(walletName);
        AgentConfiguration agentConfig = this.getAgentConfiguration();
        return AriesClientFactory.createClient((AgentConfiguration)agentConfig, (WalletRecord)wallet);
    }

    public WebSocketListener createAdminWebSocketListener() {
        return new WebSocketListener("admin", null, null);
    }

    public WebSocketClient createAdminWebSocketClient() {
        WebSocketListener wslistener = this.createAdminWebSocketListener();
        return this.createAdminWebSocketClient(wslistener);
    }

    public WebSocketClient createAdminWebSocketClient(WebSocketListener wslistener) {
        AssertArg.notNull((Object)wslistener, (String)"No wslistener");
        AssertState.isNull((Object)this.adminWebSocketClient, (String)"WebSocket client already created");
        AgentConfiguration agentConfig = this.getAgentConfiguration();
        this.adminWebSocketClient = new WebSocketClient(agentConfig, null);
        this.adminWebSocketClient.openWebSocket(wslistener);
        this.adminWebSocketListener = wslistener;
        return this.adminWebSocketClient;
    }

    public WebSocketClient getAdminWebSocketClient() {
        return this.adminWebSocketClient;
    }

    public WebSocketListener getAdminWebSocketListener() {
        return this.adminWebSocketListener;
    }

    public void closeAdminWebSocketClient() {
        if (this.adminWebSocketClient != null) {
            this.adminWebSocketClient.close();
            this.adminWebSocketListener = null;
            this.adminWebSocketClient = null;
        }
    }

    public WebSocketClient createWebSocketClient(String walletName, WebSocketListener wslistener) {
        NessusWallet wallet = this.assertWallet(walletName);
        return wallet.createWebSocketClient(this.getAgentConfiguration(), wslistener);
    }
}

