/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries;

import io.nessus.aries.util.AssertState;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.apache.camel.component.aries.handler.ConnectionsServiceHandler;
import org.apache.camel.component.aries.handler.CredentialDefinitionsServiceHandler;
import org.apache.camel.component.aries.handler.CredentialsServiceHandler;
import org.apache.camel.component.aries.handler.DidExchangeServiceHandler;
import org.apache.camel.component.aries.handler.IssueCredentialV1ServiceHandler;
import org.apache.camel.component.aries.handler.MultitenancyServiceHandler;
import org.apache.camel.component.aries.handler.OutOfBandServiceHandler;
import org.apache.camel.component.aries.handler.PresentProofServiceHandler;
import org.apache.camel.component.aries.handler.RevocationServiceHandler;
import org.apache.camel.component.aries.handler.SchemasServiceHandler;
import org.apache.camel.component.aries.handler.WalletServiceHandler;
import org.apache.camel.support.DefaultProducer;

public class HyperledgerAriesProducer
extends DefaultProducer {
    public HyperledgerAriesProducer(HyperledgerAriesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public HyperledgerAriesEndpoint getEndpoint() {
        return (HyperledgerAriesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        AbstractServiceHandler serviceHandler;
        String service = this.getService(exchange);
        if (service.startsWith("/connections")) {
            serviceHandler = new ConnectionsServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/credential-definitions")) {
            serviceHandler = new CredentialDefinitionsServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/credentials")) {
            serviceHandler = new CredentialsServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/didexchange")) {
            serviceHandler = new DidExchangeServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/issue-credential")) {
            serviceHandler = new IssueCredentialV1ServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/multitenancy")) {
            serviceHandler = new MultitenancyServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/out-of-band")) {
            serviceHandler = new OutOfBandServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/present-proof")) {
            serviceHandler = new PresentProofServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/revocation")) {
            serviceHandler = new RevocationServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/schemas")) {
            serviceHandler = new SchemasServiceHandler(this.getEndpoint());
        } else if (service.startsWith("/wallet")) {
            serviceHandler = new WalletServiceHandler(this.getEndpoint());
        } else {
            throw new UnsupportedServiceException(service);
        }
        serviceHandler.beforeProcess(exchange, service);
        serviceHandler.process(exchange, service);
        serviceHandler.afterProcess(exchange, service);
    }

    protected String getWalletName() {
        return this.getEndpoint().getWalletName();
    }

    private String getService(Exchange exchange) {
        Object service = (String)exchange.getIn().getHeader("service", String.class);
        if (service == null) {
            service = this.getEndpoint().getConfiguration().getService();
        }
        AssertState.notNull((Object)service, (String)"Cannot obtain API service");
        if (!((String)service).startsWith("/")) {
            service = "/" + (String)service;
        }
        return service;
    }
}

