/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import io.nessus.aries.util.AssertState;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.connection.ConnectionState;
import org.hyperledger.aries.api.out_of_band.InvitationMessage;
import org.hyperledger.aries.api.out_of_band.ReceiveInvitationFilter;

public class OutOfBandServiceHandler
extends AbstractServiceHandler {
    public OutOfBandServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange, String service) throws Exception {
        ReceiveInvitationFilter filter;
        InvitationMessage reqObj;
        if (service.equals("/out-of-band/receive-invitation")) {
            reqObj = this.assertBody(exchange, InvitationMessage.class);
            filter = this.maybeHeader(exchange, ReceiveInvitationFilter.class);
            if (filter == null) {
                filter = ReceiveInvitationFilter.builder().useExistingConnection(Boolean.valueOf(false)).autoAccept(Boolean.valueOf(false)).build();
            }
        } else {
            throw new UnsupportedServiceException(service);
        }
        ConnectionRecord oobRecord = (ConnectionRecord)this.createClient().outOfBandReceiveInvitation(reqObj, filter).get();
        String connectionId = oobRecord.getConnectionId();
        AssertState.notNull((Object)connectionId);
        ConnectionRecord resObj = ((List)this.adminClient().connections().get()).stream().filter(cr -> cr.getState() == ConnectionState.INVITATION).filter(cr -> cr.getConnectionId().equals(connectionId)).findFirst().orElse(null);
        AssertState.notNull((Object)resObj, (String)String.format("No ConnectionRecord for %s", connectionId));
        exchange.getMessage().setBody((Object)resObj);
    }
}

