/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.acy_py.generated.model.DIDEndpoint;

public class WalletServiceHandler
extends AbstractServiceHandler {
    public WalletServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange, String service) throws Exception {
        if (service.equals("/wallet/did/public")) {
            DID resObj = this.createClient().walletDidPublic().orElse(null);
            exchange.getIn().setBody((Object)resObj);
        } else if (service.equals("/wallet/get-did-endpoint")) {
            String did = this.assertHeader(exchange, "did", String.class);
            DIDEndpoint resObj = this.createClient().walletGetDidEndpoint(did).orElse(null);
            exchange.getIn().setBody((Object)resObj);
        } else {
            throw new UnsupportedServiceException(service);
        }
    }
}

