/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.aries;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hyperledger.aries.config.GsonConfig;

class AbstractAriesConverter {
    static final Gson GSON = GsonConfig.defaultConfig();

    protected AbstractAriesConverter() {
    }

    static <T> T toAries(JsonObject jsonObj, Class<T> type) {
        Object result = null;
        if (AbstractAriesConverter.filterFields(type, jsonObj)) {
            result = GSON.fromJson((JsonElement)jsonObj, type);
        }
        return (T)result;
    }

    static <T> T toAries(String json, Class<T> type) {
        try {
            JsonObject obj = (JsonObject)GSON.fromJson(json, JsonObject.class);
            return AbstractAriesConverter.toAries(obj, type);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    static <T> T toAries(Map<String, Object> map, Class<T> type) {
        String json = GSON.toJson(map);
        return AbstractAriesConverter.toAries(json, type);
    }

    static String toSnakeCase(String instr) {
        return instr.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    static boolean filterFields(Class<?> type, JsonObject json) {
        List acceptedFields = Arrays.asList(type.getDeclaredFields()).stream().map(f -> AbstractAriesConverter.toSnakeCase(f.getName())).collect(Collectors.toList());
        new HashSet(json.keySet()).stream().forEach(k -> {
            if (!acceptedFields.contains(k)) {
                json.remove(k);
            }
        });
        return !json.keySet().isEmpty();
    }
}

