/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hystrix.processor;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.hystrix.processor.HystrixProcessor;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.function.Suppliers;
import org.apache.camel.util.function.ThrowingSupplier;

public class HystrixReifier
extends ProcessorReifier<CircuitBreakerDefinition> {
    public HystrixReifier(Route route, CircuitBreakerDefinition definition) {
        super(route, (ProcessorDefinition)definition);
    }

    public Processor createProcessor() throws Exception {
        boolean fallbackViaNetwork;
        Processor processor = this.createChildProcessor(true);
        Processor fallback = null;
        if (((CircuitBreakerDefinition)this.definition).getOnFallback() != null) {
            fallback = this.createProcessor((ProcessorDefinition)((CircuitBreakerDefinition)this.definition).getOnFallback());
        }
        HystrixConfigurationDefinition config = this.buildHystrixConfiguration();
        String id = this.getId((OptionalIdentifiedDefinition)this.definition);
        String groupKey = config.getGroupKey();
        String threadPoolKey = config.getThreadPoolKey();
        if (groupKey == null) {
            groupKey = "CamelHystrix";
        }
        if (threadPoolKey == null) {
            threadPoolKey = groupKey;
        }
        HystrixCommandKey hcCommandKey = HystrixCommandKey.Factory.asKey((String)id);
        HystrixCommandKey hcFallbackCommandKey = HystrixCommandKey.Factory.asKey((String)(id + "-fallback"));
        HystrixCommandGroupKey hcGroupKey = HystrixCommandGroupKey.Factory.asKey((String)groupKey);
        HystrixThreadPoolKey tpKey = HystrixThreadPoolKey.Factory.asKey((String)threadPoolKey);
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)hcGroupKey).andCommandKey(hcCommandKey).andThreadPoolKey(tpKey);
        HystrixCommandProperties.Setter commandSetter = HystrixCommandProperties.Setter();
        setter.andCommandPropertiesDefaults(commandSetter);
        HystrixThreadPoolProperties.Setter threadPoolSetter = HystrixThreadPoolProperties.Setter();
        setter.andThreadPoolPropertiesDefaults(threadPoolSetter);
        this.configureHystrix(commandSetter, threadPoolSetter, config);
        HystrixCommand.Setter fallbackSetter = null;
        boolean bl = fallbackViaNetwork = ((CircuitBreakerDefinition)this.definition).getOnFallback() != null && this.parseBoolean(((CircuitBreakerDefinition)this.definition).getOnFallback().getFallbackViaNetwork(), false);
        if (fallbackViaNetwork) {
            HystrixThreadPoolKey tpFallbackKey = HystrixThreadPoolKey.Factory.asKey((String)(threadPoolKey + "-fallback"));
            fallbackSetter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)hcGroupKey).andCommandKey(hcFallbackCommandKey).andThreadPoolKey(tpFallbackKey);
            HystrixCommandProperties.Setter commandFallbackSetter = HystrixCommandProperties.Setter();
            fallbackSetter.andCommandPropertiesDefaults(commandFallbackSetter);
            HystrixThreadPoolProperties.Setter fallbackThreadPoolSetter = HystrixThreadPoolProperties.Setter();
            fallbackSetter.andThreadPoolPropertiesDefaults(fallbackThreadPoolSetter);
            this.configureHystrix(commandFallbackSetter, fallbackThreadPoolSetter, config);
        }
        return new HystrixProcessor(hcGroupKey, hcCommandKey, hcFallbackCommandKey, setter, fallbackSetter, processor, fallback, fallbackViaNetwork);
    }

    private void configureHystrix(HystrixCommandProperties.Setter command, HystrixThreadPoolProperties.Setter threadPool, HystrixConfigurationDefinition config) {
        if (config.getCircuitBreakerEnabled() != null) {
            command.withCircuitBreakerEnabled(this.parseBoolean(config.getCircuitBreakerEnabled()).booleanValue());
        }
        if (config.getCircuitBreakerErrorThresholdPercentage() != null) {
            command.withCircuitBreakerErrorThresholdPercentage(this.parseInt(config.getCircuitBreakerErrorThresholdPercentage()).intValue());
        }
        if (config.getCircuitBreakerForceClosed() != null) {
            command.withCircuitBreakerForceClosed(this.parseBoolean(config.getCircuitBreakerForceClosed()).booleanValue());
        }
        if (config.getCircuitBreakerForceOpen() != null) {
            command.withCircuitBreakerForceOpen(this.parseBoolean(config.getCircuitBreakerForceOpen()).booleanValue());
        }
        if (config.getCircuitBreakerRequestVolumeThreshold() != null) {
            command.withCircuitBreakerRequestVolumeThreshold(this.parseInt(config.getCircuitBreakerRequestVolumeThreshold()).intValue());
        }
        if (config.getCircuitBreakerSleepWindowInMilliseconds() != null) {
            command.withCircuitBreakerSleepWindowInMilliseconds(this.parseInt(config.getCircuitBreakerSleepWindowInMilliseconds()).intValue());
        }
        if (config.getExecutionIsolationSemaphoreMaxConcurrentRequests() != null) {
            command.withExecutionIsolationSemaphoreMaxConcurrentRequests(this.parseInt(config.getExecutionIsolationSemaphoreMaxConcurrentRequests()).intValue());
        }
        if (config.getExecutionIsolationStrategy() != null) {
            command.withExecutionIsolationStrategy((HystrixCommandProperties.ExecutionIsolationStrategy)this.parse(HystrixCommandProperties.ExecutionIsolationStrategy.class, config.getExecutionIsolationStrategy()));
        }
        if (config.getExecutionIsolationThreadInterruptOnTimeout() != null) {
            command.withExecutionIsolationThreadInterruptOnTimeout(this.parseBoolean(config.getExecutionIsolationThreadInterruptOnTimeout()).booleanValue());
        }
        if (config.getExecutionTimeoutInMilliseconds() != null) {
            command.withExecutionTimeoutInMilliseconds(this.parseInt(config.getExecutionTimeoutInMilliseconds()).intValue());
        }
        if (config.getExecutionTimeoutEnabled() != null) {
            command.withExecutionTimeoutEnabled(this.parseBoolean(config.getExecutionTimeoutEnabled()).booleanValue());
        }
        if (config.getFallbackIsolationSemaphoreMaxConcurrentRequests() != null) {
            command.withFallbackIsolationSemaphoreMaxConcurrentRequests(this.parseInt(config.getFallbackIsolationSemaphoreMaxConcurrentRequests()).intValue());
        }
        if (config.getFallbackEnabled() != null) {
            command.withFallbackEnabled(this.parseBoolean(config.getFallbackEnabled()).booleanValue());
        }
        if (config.getMetricsHealthSnapshotIntervalInMilliseconds() != null) {
            command.withMetricsHealthSnapshotIntervalInMilliseconds(this.parseInt(config.getMetricsHealthSnapshotIntervalInMilliseconds()).intValue());
        }
        if (config.getMetricsRollingPercentileBucketSize() != null) {
            command.withMetricsRollingPercentileBucketSize(this.parseInt(config.getMetricsRollingPercentileBucketSize()).intValue());
        }
        if (config.getMetricsRollingPercentileEnabled() != null) {
            command.withMetricsRollingPercentileEnabled(this.parseBoolean(config.getMetricsRollingPercentileEnabled()).booleanValue());
        }
        if (config.getMetricsRollingPercentileWindowInMilliseconds() != null) {
            command.withMetricsRollingPercentileWindowInMilliseconds(this.parseInt(config.getMetricsRollingPercentileWindowInMilliseconds()).intValue());
        }
        if (config.getMetricsRollingPercentileWindowBuckets() != null) {
            command.withMetricsRollingPercentileWindowBuckets(this.parseInt(config.getMetricsRollingPercentileWindowBuckets()).intValue());
        }
        if (config.getMetricsRollingStatisticalWindowInMilliseconds() != null) {
            command.withMetricsRollingStatisticalWindowInMilliseconds(this.parseInt(config.getMetricsRollingStatisticalWindowInMilliseconds()).intValue());
        }
        if (config.getMetricsRollingStatisticalWindowBuckets() != null) {
            command.withMetricsRollingStatisticalWindowBuckets(this.parseInt(config.getMetricsRollingStatisticalWindowBuckets()).intValue());
        }
        if (config.getRequestLogEnabled() != null) {
            command.withRequestLogEnabled(this.parseBoolean(config.getRequestLogEnabled()).booleanValue());
        }
        if (config.getCorePoolSize() != null) {
            threadPool.withCoreSize(this.parseInt(config.getCorePoolSize()).intValue());
        }
        if (config.getMaximumSize() != null) {
            threadPool.withMaximumSize(this.parseInt(config.getMaximumSize()).intValue());
        }
        if (config.getKeepAliveTime() != null) {
            threadPool.withKeepAliveTimeMinutes(this.parseInt(config.getKeepAliveTime()).intValue());
        }
        if (config.getMaxQueueSize() != null) {
            threadPool.withMaxQueueSize(this.parseInt(config.getMaxQueueSize()).intValue());
        }
        if (config.getQueueSizeRejectionThreshold() != null) {
            threadPool.withQueueSizeRejectionThreshold(this.parseInt(config.getQueueSizeRejectionThreshold()).intValue());
        }
        if (config.getThreadPoolRollingNumberStatisticalWindowInMilliseconds() != null) {
            threadPool.withMetricsRollingStatisticalWindowInMilliseconds(this.parseInt(config.getThreadPoolRollingNumberStatisticalWindowInMilliseconds()).intValue());
        }
        if (config.getThreadPoolRollingNumberStatisticalWindowBuckets() != null) {
            threadPool.withMetricsRollingStatisticalWindowBuckets(this.parseInt(config.getThreadPoolRollingNumberStatisticalWindowBuckets()).intValue());
        }
        if (config.getAllowMaximumSizeToDivergeFromCoreSize() != null) {
            threadPool.withAllowMaximumSizeToDivergeFromCoreSize(this.parseBoolean(config.getAllowMaximumSizeToDivergeFromCoreSize()).booleanValue());
        }
    }

    HystrixConfigurationDefinition buildHystrixConfiguration() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.loadProperties(this.camelContext, properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)this.camelContext.getExtension(Model.class)).getHystrixConfiguration(null), () -> (HystrixConfigurationDefinition)this.lookup("hystrix-configuration", HystrixConfigurationDefinition.class)}));
        if (((CircuitBreakerDefinition)this.definition).getConfigurationRef() != null) {
            String ref = this.parseString(((CircuitBreakerDefinition)this.definition).getConfigurationRef());
            this.loadProperties(this.camelContext, properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)this.camelContext.getExtension(Model.class)).getHystrixConfiguration(ref), () -> (HystrixConfigurationDefinition)this.mandatoryLookup(ref, HystrixConfigurationDefinition.class)}));
        }
        this.loadProperties(this.camelContext, properties, Optional.ofNullable(((CircuitBreakerDefinition)this.definition).getHystrixConfiguration()));
        BeanIntrospection beanIntrospection = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        beanIntrospection.getProperties((Object)this.definition, properties, null, false);
        HystrixConfigurationDefinition config = new HystrixConfigurationDefinition();
        PropertyBindingSupport.bindProperties((CamelContext)this.camelContext, (Object)config, properties);
        return config;
    }

    private void loadProperties(CamelContext camelContext, Map<String, Object> properties, Optional<?> optional) {
        BeanIntrospection beanIntrospection = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        optional.ifPresent(bean -> beanIntrospection.getProperties(bean, properties, null, false));
    }
}

