/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;

public class ObjectAddress {
    int[] address;

    private ObjectAddress(int[] address) {
        this.address = address;
    }

    public ObjectAddress(int a1, int a2, int a3, int a4, int a5) {
        this.address = new int[]{a1, a2, a3, a4, a5};
    }

    public String toString() {
        return String.format("%02d-%02d-%02d-%02d-%02d", this.address[0], this.address[1], this.address[2], this.address[3], this.address[4]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.address);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectAddress other = (ObjectAddress)obj;
        return Arrays.equals(this.address, other.address);
    }

    public static ObjectAddress valueOf(ASDUAddress asduAddress, InformationObjectAddress address) {
        Objects.requireNonNull(asduAddress);
        Objects.requireNonNull(address);
        int[] a = asduAddress.toArray();
        int[] b = address.toArray();
        return new ObjectAddress(a[0], a[1], b[0], b[1], b[2]);
    }

    public static ObjectAddress valueOf(String address) {
        if (address == null || address.isEmpty()) {
            return null;
        }
        String[] toks = address.split("-");
        if (toks.length != 5) {
            throw new IllegalArgumentException("Invalid address. Must have 5 octets.");
        }
        int[] a = new int[toks.length];
        for (int i = 0; i < toks.length; ++i) {
            int v;
            try {
                v = Integer.parseInt(toks[i]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Address segment must be numeric", e);
            }
            if (v < 0 || v > 255) {
                throw new IllegalArgumentException(String.format("Address segment must be an octet, between 0 and 255 (is %s)", v));
            }
            a[i] = v;
        }
        return new ObjectAddress(a);
    }

    public ASDUAddress getASDUAddress() {
        return ASDUAddress.fromArray((int[])new int[]{this.address[0], this.address[1]});
    }

    public InformationObjectAddress getInformationObjectAddress() {
        return InformationObjectAddress.fromArray((int[])new int[]{this.address[2], this.address[3], this.address[4]});
    }
}

