/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.cache.IgniteCacheEndpoint;
import org.apache.camel.component.ignite.compute.IgniteComputeEndpoint;
import org.apache.camel.component.ignite.events.IgniteEventsEndpoint;
import org.apache.camel.component.ignite.idgen.IgniteIdGenEndpoint;
import org.apache.camel.component.ignite.messaging.IgniteMessagingEndpoint;
import org.apache.camel.component.ignite.queue.IgniteQueueEndpoint;
import org.apache.camel.component.ignite.set.IgniteSetEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;

public class IgniteComponent
extends UriEndpointComponent {
    private IgniteConfiguration igniteConfiguration;
    private Object configurationResource;
    private Ignite ignite;
    private IgniteLifecycleMode lifecycleMode = IgniteLifecycleMode.COMPONENT_MANAGED;

    public IgniteComponent() {
        super(AbstractIgniteEndpoint.class);
    }

    public static IgniteComponent fromIgnite(Ignite ignite) {
        IgniteComponent answer = new IgniteComponent();
        answer.setIgnite(ignite);
        return answer;
    }

    public static IgniteComponent fromConfiguration(IgniteConfiguration configuration) {
        IgniteComponent answer = new IgniteComponent();
        answer.setIgniteConfiguration(configuration);
        return answer;
    }

    public static IgniteComponent fromInputStream(InputStream inputStream) {
        IgniteComponent answer = new IgniteComponent();
        answer.setConfigurationResource(inputStream);
        return answer;
    }

    public static IgniteComponent fromUrl(URL url) {
        IgniteComponent answer = new IgniteComponent();
        answer.setConfigurationResource(url);
        return answer;
    }

    public static IgniteComponent fromLocation(String location) {
        IgniteComponent answer = new IgniteComponent();
        answer.setConfigurationResource(location);
        return answer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String scheme;
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"Camel Context");
        AbstractIgniteEndpoint answer = null;
        URI remainingUri = new URI(URISupport.normalizeUri((String)remaining));
        switch (scheme = remainingUri.getScheme()) {
            case "cache": {
                answer = new IgniteCacheEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "compute": {
                answer = new IgniteComputeEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "messaging": {
                answer = new IgniteMessagingEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "events": {
                answer = new IgniteEventsEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "set": {
                answer = new IgniteSetEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "idgen": {
                answer = new IgniteIdGenEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            case "queue": {
                answer = new IgniteQueueEndpoint(uri, remainingUri, parameters, this);
                break;
            }
            default: {
                throw new MalformedURLException("An invalid Ignite endpoint URI was provided. Please check that it starts with: ignite:[cache/compute/messaging/...]:...");
            }
        }
        this.setProperties((Object)answer, parameters);
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doStart() throws Exception {
        super.doStart();
        if (this.lifecycleMode == IgniteLifecycleMode.USER_MANAGED) {
            return;
        }
        if (this.configurationResource != null) {
            if (this.configurationResource instanceof URL) {
                this.ignite = Ignition.start((URL)((URL)this.configurationResource));
                return;
            } else if (this.configurationResource instanceof InputStream) {
                this.ignite = Ignition.start((InputStream)((InputStream)this.configurationResource));
                return;
            } else {
                if (!(this.configurationResource instanceof String)) throw new IllegalStateException("An unsupported configuration resource was provided to the Ignite component. Supported types are: URL, InputStream, String.");
                this.ignite = Ignition.start((String)((String)this.configurationResource));
            }
            return;
        } else {
            if (this.igniteConfiguration == null) throw new IllegalStateException("No configuration resource or IgniteConfiguration was provided to the Ignite component.");
            this.ignite = Ignition.start((IgniteConfiguration)this.igniteConfiguration);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.lifecycleMode == IgniteLifecycleMode.USER_MANAGED) {
            return;
        }
        this.ignite.close();
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    public void setIgnite(Ignite ignite) {
        this.ignite = ignite;
    }

    public Object getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(Object configurationResource) {
        this.configurationResource = configurationResource;
    }

    public IgniteConfiguration getIgniteConfiguration() {
        return this.igniteConfiguration;
    }

    public void setIgniteConfiguration(IgniteConfiguration igniteConfiguration) {
        this.igniteConfiguration = igniteConfiguration;
    }

    public static enum IgniteLifecycleMode {
        USER_MANAGED,
        COMPONENT_MANAGED;

    }
}

