/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

public class InfinispanUtil {
    protected InfinispanUtil() {
    }

    public static boolean isInHeaderEmpty(Exchange exchange, String header) {
        return InfinispanUtil.isHeaderEmpty(exchange.getMessage(), header);
    }

    public static boolean isHeaderEmpty(Message message, String header) {
        return ObjectHelper.isEmpty((Object)message.getHeader(header));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadProperties(CamelContext camelContext, String uri) throws Exception {
        try (InputStream is = InfinispanUtil.openInputStream(camelContext, uri);){
            Properties properties = new Properties();
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Cannot find resource: " + uri);
        }
    }

    public static InputStream openInputStream(CamelContext camelContext, String uri) throws Exception {
        if (camelContext != null) {
            uri = camelContext.resolvePropertyPlaceholders(uri);
            return ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)uri);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(CamelContext camelContext, Object source) {
        return camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor(source, source.getClass().getSimpleName());
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(CamelContextAware camelContextAware, Object source) {
        return InfinispanUtil.newSingleThreadScheduledExecutor(camelContextAware.getCamelContext(), source);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(CamelContext camelContext, Object source, String id) {
        return camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor(source, source.getClass().getSimpleName() + "-" + id);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(CamelContextAware camelContextAware, Object source, String id) {
        return InfinispanUtil.newSingleThreadScheduledExecutor(camelContextAware.getCamelContext(), source, id);
    }
}

