/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.spi.Metadata;

public interface InfinispanConstants {
    public static final String SCHEME_INFINISPAN = "infinispan";
    public static final String SCHEME_EMBEDDED = "infinispan-embedded";
    public static final String CACHE_MANAGER_CURRENT = "current";
    @Metadata(label="consumer", description="The type of the received event.", javaType="String")
    public static final String EVENT_TYPE = "CamelInfinispanEventType";
    @Metadata(label="consumer", description="true if the notification is before the event has occurred, false if after the event has occurred.", javaType="boolean", applicableFor={"infinispan-embedded"})
    public static final String IS_PRE = "CamelInfinispanIsPre";
    @Metadata(description="The cache participating in the operation or event.", javaType="String")
    public static final String CACHE_NAME = "CamelInfinispanCacheName";
    @Metadata(description="The key to perform the operation to or the key generating the event.", javaType="Object")
    public static final String KEY = "CamelInfinispanKey";
    @Metadata(label="producer", description="The value to use for the operation.", javaType="Object")
    public static final String VALUE = "CamelInfinispanValue";
    @Metadata(label="producer", description="The default value to use for a getOrDefault.", javaType="Object")
    public static final String DEFAULT_VALUE = "CamelInfinispanDefaultValue";
    @Metadata(label="producer", description="The old value to use for a replace.", javaType="Object")
    public static final String OLD_VALUE = "CamelInfinispanOldValue";
    @Metadata(label="producer", description="A Map to use in case of `CamelInfinispanOperationPutAll` operation", javaType="Map")
    public static final String MAP = "CamelInfinispanMap";
    @Metadata(label="producer", description="The operation to perform.", javaType="org.apache.camel.component.infinispan.InfinispanOperation")
    public static final String OPERATION = "CamelInfinispanOperation";
    @Metadata(label="producer", description="The name of the header whose value is the result", javaType="String")
    public static final String RESULT = "CamelInfinispanOperationResult";
    @Metadata(label="producer", description="Store the operation result in a header instead of the message body", javaType="String")
    public static final String RESULT_HEADER = "CamelInfinispanOperationResultHeader";
    @Metadata(label="producer", description="The Lifespan time of a value inside the cache. Negative values are interpreted as infinity.", javaType="long")
    public static final String LIFESPAN_TIME = "CamelInfinispanLifespanTime";
    @Metadata(label="producer", description="The Time Unit of an entry Lifespan Time.", javaType="java.util.concurrent.TimeUnit")
    public static final String LIFESPAN_TIME_UNIT = "CamelInfinispanTimeUnit";
    @Metadata(label="producer", description="The maximum amount of time an entry is allowed to be idle for before it is considered as expired.", javaType="long")
    public static final String MAX_IDLE_TIME = "CamelInfinispanMaxIdleTime";
    @Metadata(label="producer", description="The Time Unit of an entry Max Idle Time.", javaType="java.util.concurrent.TimeUnit")
    public static final String MAX_IDLE_TIME_UNIT = "CamelInfinispanMaxIdleTimeUnit";
    @Metadata(label="consumer", description="Signals that a write operation's return value will be ignored, so reading the existing value from a store or from a remote node is not necessary.", javaType="boolean", defaultValue="false", applicableFor={"infinispan-embedded"})
    public static final String IGNORE_RETURN_VALUES = "CamelInfinispanIgnoreReturnValues";
    @Metadata(label="consumer", description="The event data.", javaType="Object")
    public static final String EVENT_DATA = "CamelInfinispanEventData";
    @Metadata(label="producer", description="The QueryBuilder to use for QUERY command, if not present the command defaults to InifinispanConfiguration's one", javaType="org.apache.camel.component.infinispan.InfinispanQueryBuilder")
    public static final String QUERY_BUILDER = "CamelInfinispanQueryBuilder";
    @Metadata(label="consumer", description="Provides access to the version of the created cache entry.", javaType="long", applicableFor={"infinispan"})
    public static final String ENTRY_VERSION = "CamelInfinispanEntryVersion";
    @Metadata(label="consumer", description="This will be true if the write command that caused this had to be retried again due to a topology change.", javaType="boolean")
    public static final String COMMAND_RETRIED = "CamelInfinispanCommandRetried";
    @Metadata(label="consumer", description="Indicates whether the cache entry modification event is the result of the cache entry being created.", javaType="boolean", applicableFor={"infinispan-embedded"})
    public static final String ENTRY_CREATED = "CamelInfinispanEntryCreated";
    @Metadata(label="consumer", description="true if the call originated on the local cache instance; false if originated from a remote one.", javaType="boolean", applicableFor={"infinispan-embedded"})
    public static final String ORIGIN_LOCAL = "CamelInfinispanOriginLocal";
    @Metadata(label="consumer", description="True if this event is generated from an existing entry as the listener has Listener.", javaType="boolean", applicableFor={"infinispan-embedded"})
    public static final String CURRENT_STATE = "CamelInfinispanCurrentState";
    public static final String CACHE_ENTRY_JOINING = "CacheEntryJoining";
    public static final String CACHE_ENTRY_LEAVING = "CacheEntryLeaving";
    public static final String CACHE_ENTRY_UPDATED = "CacheEntryUpdated";
}

