/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import java.util.Collections;
import java.util.Set;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.Event;

public abstract class InfinispanEmbeddedEventListener
extends InfinispanEventListener<Event.Type> {
    protected InfinispanEmbeddedEventListener() {
        super(Collections.emptySet());
    }

    protected InfinispanEmbeddedEventListener(Set<Event.Type> events) {
        super(events);
    }

    @CacheEntryActivated
    public void processEvent(CacheEntryActivatedEvent<?, ?> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), event.getCache().getName(), event.getKey(), event.getValue(), e -> e.getMessage().setHeader("CamelInfinispanIsPre", (Object)event.isPre()));
        }
    }

    @CacheEntryCreated
    public void processEvent(CacheEntryCreatedEvent<?, ?> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), event.getCache().getName(), event.getKey(), event.getValue(), e -> {
                e.getMessage().setHeader("CamelInfinispanIsPre", (Object)event.isPre());
                e.getMessage().setHeader("CamelInfinispanCommandRetried", (Object)event.isCommandRetried());
            });
        }
    }

    @CacheEntryInvalidated
    public void processEvent(CacheEntryInvalidatedEvent<?, ?> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), event.getCache().getName(), event.getKey(), event.getValue(), e -> e.getMessage().setHeader("CamelInfinispanIsPre", (Object)event.isPre()));
        }
    }

    @CacheEntryLoaded
    public void processEvent(CacheEntryLoadedEvent<?, ?> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), event.getCache().getName(), event.getKey(), event.getValue(), e -> e.getMessage().setHeader("CamelInfinispanIsPre", (Object)event.isPre()));
        }
    }

    @CacheEntryModified
    public void processEvent(CacheEntryModifiedEvent<?, ?> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), event.getCache().getName(), event.getKey(), event.getValue(), e -> {
                e.getMessage().setHeader("CamelInfinispanIsPre", (Object)event.isPre());
                e.getMessage().setHeader("CamelInfinispanCommandRetried", (Object)event.isCommandRetried());
                e.getMessage().setHeader("CamelInfinispanEntryCreated", (Object)event.isCreated());
                e.getMessage().setHeader("CamelInfinispanOriginLocal", (Object)event.isOriginLocal());
                e.getMessage().setHeader("CamelInfinispanCurrentState", (Object)event.isCurrentState());
            });
        }
    }

    @CacheEntryPassivated
    public void processEvent(CacheEntryPassivatedEvent<?, ?> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), event.getCache().getName(), event.getKey(), event.getValue(), e -> {
                e.getMessage().setHeader("CamelInfinispanIsPre", (Object)event.isPre());
                e.getMessage().setHeader("CamelInfinispanOriginLocal", (Object)event.isOriginLocal());
                e.getMessage().setHeader("CamelInfinispanCurrentState", (Object)event.isCurrentState());
            });
        }
    }

    @CacheEntryRemoved
    public void processEvent(CacheEntryRemovedEvent<?, ?> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), event.getCache().getName(), event.getKey(), event.getValue(), e -> {
                e.getMessage().setHeader("CamelInfinispanIsPre", (Object)event.isPre());
                e.getMessage().setHeader("CamelInfinispanCommandRetried", (Object)event.isCommandRetried());
                e.getMessage().setHeader("CamelInfinispanOriginLocal", (Object)event.isOriginLocal());
                e.getMessage().setHeader("CamelInfinispanCurrentState", (Object)event.isCurrentState());
                e.getMessage().setHeader("CamelInfinispanOldValue", event.getOldValue());
            });
        }
    }

    @CacheEntryVisited
    public void processEvent(CacheEntryVisitedEvent<?, ?> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), event.getCache().getName(), event.getKey(), event.getValue(), e -> {
                e.getMessage().setHeader("CamelInfinispanIsPre", (Object)event.isPre());
                e.getMessage().setHeader("CamelInfinispanOriginLocal", (Object)event.isOriginLocal());
                e.getMessage().setHeader("CamelInfinispanCurrentState", (Object)event.isCurrentState());
            });
        }
    }

    @CacheEntryExpired
    public void processEvent(CacheEntryExpiredEvent<?, ?> event) {
        if (this.isAccepted(event.getType())) {
            this.getEventProcessor().processEvent(event.getType().toString(), event.getCache().getName(), event.getKey(), event.getValue(), e -> {
                e.getMessage().setHeader("CamelInfinispanIsPre", (Object)event.isPre());
                e.getMessage().setHeader("CamelInfinispanOriginLocal", (Object)event.isOriginLocal());
                e.getMessage().setHeader("CamelInfinispanCurrentState", (Object)event.isCurrentState());
            });
        }
    }
}

