/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfinispanEmbeddedManager
extends ServiceSupport
implements InfinispanManager<EmbeddedCacheManager> {
    private final InfinispanEmbeddedConfiguration configuration;
    private CamelContext camelContext;
    private EmbeddedCacheManager cacheContainer;
    private boolean isManagedCacheContainer;

    public InfinispanEmbeddedManager() {
        this(null, new InfinispanEmbeddedConfiguration());
    }

    public InfinispanEmbeddedManager(InfinispanEmbeddedConfiguration configuration) {
        this(null, configuration);
    }

    public InfinispanEmbeddedManager(CamelContext camelContext, InfinispanEmbeddedConfiguration configuration) {
        this.camelContext = camelContext;
        this.configuration = configuration;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void doStart() throws Exception {
        this.cacheContainer = this.configuration.getCacheContainer();
        if (this.cacheContainer == null) {
            Configuration containerConf = this.configuration.getCacheContainerConfiguration();
            this.cacheContainer = containerConf != null ? new DefaultCacheManager(new GlobalConfigurationBuilder().defaultCacheName("default").build(), containerConf, true) : (ObjectHelper.isNotEmpty((Object)this.configuration.getConfigurationUri()) ? new DefaultCacheManager(InfinispanUtil.openInputStream((CamelContext)this.camelContext, (String)this.configuration.getConfigurationUri()), true) : new DefaultCacheManager(new GlobalConfigurationBuilder().defaultCacheName("default").build(), new ConfigurationBuilder().build()));
            this.isManagedCacheContainer = true;
        }
    }

    public void doStop() throws Exception {
        if (this.isManagedCacheContainer) {
            this.cacheContainer.stop();
        }
        super.doStop();
    }

    public EmbeddedCacheManager getCacheContainer() {
        return this.cacheContainer;
    }

    public <K, V> BasicCache<K, V> getCache() {
        Cache cache = this.cacheContainer.getCache();
        return this.configuration.hasFlags() ? cache.getAdvancedCache().withFlags(this.configuration.getFlags()) : cache;
    }

    public <K, V> BasicCache<K, V> getCache(String cacheName) {
        Cache cache = ObjectHelper.isEmpty((Object)cacheName) || "current".equals(cacheName) ? this.cacheContainer.getCache() : this.cacheContainer.getCache(cacheName);
        return this.configuration.hasFlags() ? cache.getAdvancedCache().withFlags(this.configuration.getFlags()) : cache;
    }

    public <K, V> BasicCache<K, V> getCache(Message message, String defaultCache) {
        String cacheName = (String)message.getHeader("CamelInfinispanCacheName", (Object)defaultCache, String.class);
        Cache cache = (Cache)this.getCache(cacheName);
        return (Boolean)message.getHeader("CamelInfinispanIgnoreReturnValues", (Object)false, Boolean.TYPE) != false ? cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES) : cache;
    }

    public Set<String> getCacheNames() {
        return this.cacheContainer.getCacheNames();
    }
}

