/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded.cluster;

import java.util.concurrent.TimeUnit;
import org.apache.camel.component.infinispan.cluster.InfinispanClusterService;
import org.apache.camel.component.infinispan.cluster.InfinispanClusterView;
import org.apache.camel.component.infinispan.embedded.cluster.InfinispanEmbeddedClusterConfiguration;
import org.apache.camel.component.infinispan.embedded.cluster.InfinispanEmbeddedClusterView;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanEmbeddedClusterService
extends InfinispanClusterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanEmbeddedClusterService.class);
    private InfinispanEmbeddedClusterConfiguration configuration;

    public InfinispanEmbeddedClusterService() {
        this.configuration = new InfinispanEmbeddedClusterConfiguration();
    }

    public InfinispanEmbeddedClusterService(InfinispanEmbeddedClusterConfiguration configuration) {
        this.configuration = configuration.clone();
    }

    public InfinispanEmbeddedClusterConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanEmbeddedClusterConfiguration configuration) {
        this.configuration = configuration.clone();
    }

    public void setConfigurationUri(String configurationUri) {
        this.configuration.setConfigurationUri(configurationUri);
    }

    public EmbeddedCacheManager getCacheContainer() {
        return this.configuration.getCacheContainer();
    }

    public void setCacheContainer(EmbeddedCacheManager cacheContainer) {
        this.configuration.setCacheContainer(cacheContainer);
    }

    public Configuration getCacheContainerConfiguration() {
        return this.configuration.getCacheContainerConfiguration();
    }

    public void setCacheContainerConfiguration(Configuration cacheContainerConfiguration) {
        this.configuration.setCacheContainerConfiguration(cacheContainerConfiguration);
    }

    public long getLifespan() {
        return this.configuration.getLifespan();
    }

    public void setLifespan(long lifespan) {
        this.configuration.setLifespan(lifespan);
    }

    public TimeUnit getLifespanTimeUnit() {
        return this.configuration.getLifespanTimeUnit();
    }

    public void setLifespanTimeUnit(TimeUnit lifespanTimeUnit) {
        this.configuration.setLifespanTimeUnit(lifespanTimeUnit);
    }

    protected InfinispanClusterView createView(String namespace) throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"Camel Context");
        ObjectHelper.notNull((Object)this.getId(), (String)"Cluster ID");
        return new InfinispanEmbeddedClusterView(this, this.configuration, namespace);
    }
}

