/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.component.infinispan.InfinispanComponent;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedEndpoint;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedManager;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.service.ServiceHelper;

@Component(value="infinispan-embedded")
public class InfinispanEmbeddedComponent
extends InfinispanComponent {
    public static final String SCHEME = "infinispan-embedded";
    @Metadata(description="Component configuration")
    private InfinispanEmbeddedConfiguration configuration = new InfinispanEmbeddedConfiguration();
    private InfinispanEmbeddedManager manager;

    public InfinispanEmbeddedComponent() {
    }

    public InfinispanEmbeddedComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        InfinispanEmbeddedConfiguration conf = this.configuration.clone();
        InfinispanEmbeddedEndpoint endpoint = new InfinispanEmbeddedEndpoint(uri, remaining, this, conf);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.manager = new InfinispanEmbeddedManager(this.configuration);
        ServiceHelper.initService((Object)((Object)this.manager));
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.manager);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Service)this.manager);
    }

    public InfinispanEmbeddedManager getManager() {
        return this.manager;
    }

    public void setConfiguration(InfinispanEmbeddedConfiguration configuration) {
        this.configuration = configuration;
    }

    public InfinispanEmbeddedConfiguration getConfiguration() {
        return this.configuration;
    }
}

