/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.infinispan.InfinispanComponent;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanConsumer;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.InfinispanProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.13.0", scheme="infinispan", title="Infinispan", syntax="infinispan:cacheName", label="cache,datagrid,clustering")
public class InfinispanEndpoint
extends DefaultEndpoint {
    @UriPath(description="The cache to use")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final InfinispanConfiguration configuration;
    private final InfinispanManager manager;

    public InfinispanEndpoint(String uri, String cacheName, InfinispanComponent component, InfinispanConfiguration configuration) {
        super(uri, (Component)component);
        this.cacheName = cacheName;
        this.configuration = configuration;
        this.manager = new InfinispanManager(component.getCamelContext(), configuration);
    }

    protected void doStart() throws Exception {
        this.manager.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.manager.stop();
    }

    public Producer createProducer() throws Exception {
        return new InfinispanProducer(this, this.cacheName, this.manager, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new InfinispanConsumer(this, processor, this.cacheName, this.manager, this.configuration);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public InfinispanConfiguration getConfiguration() {
        return this.configuration;
    }
}

