/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Arrays;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="infinispan")
public class InfinispanComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(InfinispanComponent.class);
    @Metadata(description="Default configuration")
    private InfinispanConfiguration configuration;
    @Metadata(description="Default Cache container")
    private BasicCacheContainer cacheContainer;
    private boolean setCacheFromComponent;

    public InfinispanComponent() {
    }

    public InfinispanComponent(CamelContext camelContext) {
        super(camelContext);
    }

    public InfinispanConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanConfiguration configuration) {
        this.configuration = configuration;
    }

    public BasicCacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    public void setCacheContainer(BasicCacheContainer cacheContainer) {
        this.cacheContainer = cacheContainer;
        this.setCacheFromComponent = true;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        InfinispanConfiguration conf = this.configuration != null ? this.configuration.copy() : new InfinispanConfiguration();
        if (!this.isConfigProvided(parameters, conf) || this.setCacheFromComponent) {
            if (this.cacheContainer == null) {
                this.cacheContainer = new DefaultCacheManager(new GlobalConfigurationBuilder().defaultCacheName("default").build(), new ConfigurationBuilder().build());
                this.setCacheFromComponent = false;
                LOG.debug("Default cacheContainer has been created");
            }
            conf.setCacheContainer(this.cacheContainer);
        } else {
            conf.setCacheContainer(null);
        }
        InfinispanEndpoint endpoint = new InfinispanEndpoint(uri, remaining, this, conf);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    private boolean isConfigProvided(Map<String, Object> parameters, InfinispanConfiguration conf) {
        if (conf.getHosts() != null) {
            return true;
        }
        if (conf.getCacheContainer() != null) {
            return true;
        }
        if (conf.getCacheContainerConfiguration() != null) {
            return true;
        }
        if (conf.getConfigurationUri() != null) {
            return true;
        }
        String[] confParameters = new String[]{"hosts", "cacheContainerConfiguration", "configurationUri", "cacheContainer"};
        return Arrays.stream(confParameters).anyMatch(parameters::containsKey);
    }
}

