/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.function.Supplier;
import org.apache.camel.component.infinispan.InfinispanAggregationRepository;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteUtil;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.function.Suppliers;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;

public class InfinispanRemoteAggregationRepository
extends InfinispanAggregationRepository {
    private final Supplier<BasicCache<String, DefaultExchangeHolder>> cache = Suppliers.memorize(() -> InfinispanRemoteUtil.getCacheWithFlags(this.manager, this.getCacheName(), Flag.FORCE_RETURN_VALUE));
    private InfinispanRemoteConfiguration configuration;
    private InfinispanRemoteManager manager;

    public InfinispanRemoteAggregationRepository(String cacheName) {
        super(cacheName);
    }

    protected void doStart() throws Exception {
        InfinispanRemoteConfiguration conf;
        super.doStart();
        InfinispanRemoteConfiguration infinispanRemoteConfiguration = conf = this.configuration != null ? this.configuration : new InfinispanRemoteConfiguration();
        if (conf.getCacheContainerConfiguration() == null) {
            conf.setCacheContainerConfiguration(new ConfigurationBuilder().marshaller(JBossUserMarshaller.class).build());
        } else {
            conf.setCacheContainerConfiguration(new ConfigurationBuilder().read(conf.getCacheContainerConfiguration()).marshaller(JBossUserMarshaller.class).build());
        }
        this.manager = new InfinispanRemoteManager(conf);
        this.manager.setCamelContext(this.getCamelContext());
        ServiceHelper.startService((Object)((Object)this.manager));
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)((Object)this.manager));
    }

    protected BasicCache<String, DefaultExchangeHolder> getCache() {
        return this.cache.get();
    }

    public InfinispanRemoteConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanRemoteConfiguration configuration) {
        this.configuration = configuration;
    }
}

