/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;

public class InfinispanRemoteManager
extends ServiceSupport
implements InfinispanManager<RemoteCacheManager> {
    private final InfinispanRemoteConfiguration configuration;
    private CamelContext camelContext;
    private RemoteCacheManager cacheContainer;
    private boolean isManagedCacheContainer;

    public InfinispanRemoteManager() {
        this(null, new InfinispanRemoteConfiguration());
    }

    public InfinispanRemoteManager(InfinispanRemoteConfiguration configuration) {
        this(null, configuration);
    }

    public InfinispanRemoteManager(CamelContext camelContext, InfinispanRemoteConfiguration configuration) {
        this.camelContext = camelContext;
        this.configuration = configuration;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void doStart() throws Exception {
        this.cacheContainer = this.configuration.getCacheContainer();
        if (this.cacheContainer == null) {
            Configuration containerConf = this.configuration.getCacheContainerConfiguration();
            if (containerConf != null) {
                this.cacheContainer = new RemoteCacheManager(containerConf, true);
            }
            if (this.cacheContainer == null) {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.addServers(this.configuration.getHosts());
                if (this.camelContext != null && this.camelContext.getApplicationContextClassLoader() != null) {
                    builder.classLoader(this.camelContext.getApplicationContextClassLoader());
                } else {
                    builder.classLoader(Thread.currentThread().getContextClassLoader());
                }
                if (this.configuration.isSecure()) {
                    if (!ObjectHelper.isNotEmpty((Object)this.configuration.getUsername()) || !ObjectHelper.isNotEmpty((Object)this.configuration.getPassword())) {
                        throw new IllegalArgumentException("If the Infinispan instance is secured, username and password are needed");
                    }
                    builder.security().authentication().username(this.configuration.getUsername()).password(this.configuration.getPassword());
                    if (ObjectHelper.isNotEmpty((Object)this.configuration.getSaslMechanism())) {
                        builder.security().authentication().saslMechanism(this.configuration.getSaslMechanism());
                    }
                    if (ObjectHelper.isNotEmpty((Object)this.configuration.getSecurityRealm())) {
                        builder.security().authentication().realm(this.configuration.getSecurityRealm());
                    }
                    if (ObjectHelper.isNotEmpty((Object)this.configuration.getSecurityServerName())) {
                        builder.security().authentication().serverName(this.configuration.getSecurityServerName());
                    }
                }
                Properties properties = new Properties();
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getConfigurationUri())) {
                    properties.putAll((Map<?, ?>)InfinispanUtil.loadProperties((CamelContext)this.camelContext, (String)this.configuration.getConfigurationUri()));
                }
                if (ObjectHelper.isNotEmpty(this.configuration.getConfigurationProperties())) {
                    this.configuration.getConfigurationProperties().forEach((k, v) -> properties.put(k.startsWith("infinispan.client.hotrod.") ? k : "infinispan.client.hotrod." + k, v));
                }
                if (!properties.isEmpty()) {
                    builder.withProperties(properties);
                }
                this.cacheContainer = new RemoteCacheManager(builder.build(), true);
            }
            this.isManagedCacheContainer = true;
        }
    }

    public void doStop() throws Exception {
        if (this.isManagedCacheContainer) {
            this.cacheContainer.stop();
        }
    }

    public RemoteCacheManager getCacheContainer() {
        return this.cacheContainer;
    }

    public <K, V> BasicCache<K, V> getCache() {
        RemoteCache cache = this.cacheContainer.getCache();
        return this.configuration.hasFlags() ? cache.withFlags(this.configuration.getFlags()) : cache;
    }

    public <K, V> BasicCache<K, V> getCache(String cacheName) {
        RemoteCache cache = ObjectHelper.isEmpty((Object)cacheName) || "current".equals(cacheName) ? this.cacheContainer.getCache() : this.cacheContainer.getCache(cacheName);
        return this.configuration.hasFlags() ? cache.withFlags(this.configuration.getFlags()) : cache;
    }

    public Set<String> getCacheNames() {
        return this.cacheContainer.getCacheNames();
    }
}

