/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.infinispan.InfinispanCustomListener;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.infinispan.commons.api.BasicCacheContainer;

public class InfinispanEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        InfinispanEndpoint target = (InfinispanEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "cachecontainer": 
            case "cacheContainer": {
                target.getConfiguration().setCacheContainer((BasicCacheContainer)InfinispanEndpointConfigurer.property((CamelContext)camelContext, BasicCacheContainer.class, (Object)value));
                return true;
            }
            case "cachecontainerconfiguration": 
            case "cacheContainerConfiguration": {
                target.getConfiguration().setCacheContainerConfiguration(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "clusteredlistener": 
            case "clusteredListener": {
                target.getConfiguration().setClusteredListener((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "command": {
                target.getConfiguration().setCommand((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configurationproperties": 
            case "configurationProperties": {
                target.getConfiguration().setConfigurationProperties((Map)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "configurationuri": 
            case "configurationUri": {
                target.getConfiguration().setConfigurationUri((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "customlistener": 
            case "customListener": {
                target.getConfiguration().setCustomListener((InfinispanCustomListener)InfinispanEndpointConfigurer.property((CamelContext)camelContext, InfinispanCustomListener.class, (Object)value));
                return true;
            }
            case "defaultvalue": 
            case "defaultValue": {
                target.getConfiguration().setDefaultValue(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "eventtypes": 
            case "eventTypes": {
                target.getConfiguration().setEventTypes((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)InfinispanEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)InfinispanEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "flags": {
                target.getConfiguration().setFlags((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "hosts": {
                target.getConfiguration().setHosts((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "key": {
                target.getConfiguration().setKey(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "oldvalue": 
            case "oldValue": {
                target.getConfiguration().setOldValue(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "operation": {
                target.getConfiguration().setOperation((InfinispanOperation)((Object)InfinispanEndpointConfigurer.property((CamelContext)camelContext, InfinispanOperation.class, (Object)value)));
                return true;
            }
            case "password": {
                target.getConfiguration().setPassword((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "querybuilder": 
            case "queryBuilder": {
                target.getConfiguration().setQueryBuilder((InfinispanQueryBuilder)InfinispanEndpointConfigurer.property((CamelContext)camelContext, InfinispanQueryBuilder.class, (Object)value));
                return true;
            }
            case "remappingfunction": 
            case "remappingFunction": {
                target.getConfiguration().setRemappingFunction((BiFunction)InfinispanEndpointConfigurer.property((CamelContext)camelContext, BiFunction.class, (Object)value));
                return true;
            }
            case "resultheader": 
            case "resultHeader": {
                target.getConfiguration().setResultHeader(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "saslmechanism": 
            case "saslMechanism": {
                target.getConfiguration().setSaslMechanism((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secure": {
                target.getConfiguration().setSecure((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "securityrealm": 
            case "securityRealm": {
                target.getConfiguration().setSecurityRealm((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securityservername": 
            case "securityServerName": {
                target.getConfiguration().setSecurityServerName((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sync": {
                target.getConfiguration().setSync((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "username": {
                target.getConfiguration().setUsername((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "value": {
                target.getConfiguration().setValue(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        InfinispanEndpoint target = (InfinispanEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "cachecontainer": 
            case "cacheContainer": {
                return target.getConfiguration().getCacheContainer();
            }
            case "cachecontainerconfiguration": 
            case "cacheContainerConfiguration": {
                return target.getConfiguration().getCacheContainerConfiguration();
            }
            case "clusteredlistener": 
            case "clusteredListener": {
                return target.getConfiguration().isClusteredListener();
            }
            case "command": {
                return target.getConfiguration().getCommand();
            }
            case "configurationproperties": 
            case "configurationProperties": {
                return target.getConfiguration().getConfigurationProperties();
            }
            case "configurationuri": 
            case "configurationUri": {
                return target.getConfiguration().getConfigurationUri();
            }
            case "customlistener": 
            case "customListener": {
                return target.getConfiguration().getCustomListener();
            }
            case "defaultvalue": 
            case "defaultValue": {
                return target.getConfiguration().getDefaultValue();
            }
            case "eventtypes": 
            case "eventTypes": {
                return target.getConfiguration().getEventTypes();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "flags": {
                return target.getConfiguration().getFlags();
            }
            case "hosts": {
                return target.getConfiguration().getHosts();
            }
            case "key": {
                return target.getConfiguration().getKey();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "oldvalue": 
            case "oldValue": {
                return target.getConfiguration().getOldValue();
            }
            case "operation": {
                return target.getConfiguration().getOperation();
            }
            case "password": {
                return target.getConfiguration().getPassword();
            }
            case "querybuilder": 
            case "queryBuilder": {
                return target.getConfiguration().getQueryBuilder();
            }
            case "remappingfunction": 
            case "remappingFunction": {
                return target.getConfiguration().getRemappingFunction();
            }
            case "resultheader": 
            case "resultHeader": {
                return target.getConfiguration().getResultHeader();
            }
            case "saslmechanism": 
            case "saslMechanism": {
                return target.getConfiguration().getSaslMechanism();
            }
            case "secure": {
                return target.getConfiguration().isSecure();
            }
            case "securityrealm": 
            case "securityRealm": {
                return target.getConfiguration().getSecurityRealm();
            }
            case "securityservername": 
            case "securityServerName": {
                return target.getConfiguration().getSecurityServerName();
            }
            case "sync": {
                return target.getConfiguration().isSync();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "username": {
                return target.getConfiguration().getUsername();
            }
            case "value": {
                return target.getConfiguration().getValue();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("cacheName", String.class);
        map.put("hosts", String.class);
        map.put("queryBuilder", InfinispanQueryBuilder.class);
        map.put("secure", Boolean.TYPE);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("clusteredListener", Boolean.TYPE);
        map.put("command", String.class);
        map.put("customListener", InfinispanCustomListener.class);
        map.put("eventTypes", String.class);
        map.put("sync", Boolean.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("defaultValue", Object.class);
        map.put("key", Object.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("oldValue", Object.class);
        map.put("operation", InfinispanOperation.class);
        map.put("value", Object.class);
        map.put("password", String.class);
        map.put("saslMechanism", String.class);
        map.put("securityRealm", String.class);
        map.put("securityServerName", String.class);
        map.put("username", String.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("cacheContainer", BasicCacheContainer.class);
        map.put("cacheContainerConfiguration", Object.class);
        map.put("configurationProperties", Map.class);
        map.put("configurationUri", String.class);
        map.put("flags", String.class);
        map.put("remappingFunction", BiFunction.class);
        map.put("resultHeader", Object.class);
        map.put("synchronous", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

