/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.infinispan.InfinispanComponent;
import org.apache.camel.component.infinispan.InfinispanConstants;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConsumer;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.service.ServiceHelper;

@UriEndpoint(firstVersion="2.13.0", scheme="infinispan", title="Infinispan", syntax="infinispan:cacheName", category={Category.CACHE, Category.CLUSTERING}, headersClass=InfinispanConstants.class)
public class InfinispanRemoteEndpoint
extends InfinispanEndpoint {
    @UriPath(description="The name of the cache to use. Use current to use the existing cache name from the currently configured cached manager. Or use default for the default cache manager name.")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final InfinispanRemoteConfiguration configuration;
    private final InfinispanRemoteManager manager;

    public InfinispanRemoteEndpoint(String uri, String cacheName, InfinispanComponent component, InfinispanRemoteConfiguration configuration) {
        super(uri, (Component)component);
        this.cacheName = cacheName;
        this.configuration = configuration;
        this.manager = new InfinispanRemoteManager(component.getCamelContext(), configuration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.manager);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Service)this.manager);
    }

    public Producer createProducer() throws Exception {
        return new InfinispanRemoteProducer(this, this.cacheName, this.manager, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        InfinispanRemoteConsumer consumer = new InfinispanRemoteConsumer(this, processor, this.cacheName, this.manager, this.configuration);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public InfinispanRemoteConfiguration getConfiguration() {
        return this.configuration;
    }
}

